/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class MergeSortNode
extends MultiChildProcessNode {
    private final OrderingScheme orderingScheme;
    private final List<Symbol> outputSymbols;

    public MergeSortNode(PlanNodeId id, OrderingScheme orderingScheme, List<Symbol> outputSymbols) {
        super(id);
        this.orderingScheme = orderingScheme;
        this.outputSymbols = outputSymbols;
    }

    public MergeSortNode(PlanNodeId id, List<PlanNode> children, OrderingScheme orderingScheme, List<Symbol> outputSymbols) {
        super(id, children);
        this.orderingScheme = orderingScheme;
        this.outputSymbols = outputSymbols;
    }

    @Override
    public PlanNode clone() {
        return new MergeSortNode(this.getPlanNodeId(), this.orderingScheme, this.outputSymbols);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitMergeSort(this, context);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_MERGESORT_NODE.serialize(byteBuffer);
        this.orderingScheme.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputSymbols.size(), (ByteBuffer)byteBuffer);
        for (Symbol symbol : this.outputSymbols) {
            Symbol.serialize(symbol, byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_MERGESORT_NODE.serialize(stream);
        this.orderingScheme.serialize(stream);
        ReadWriteIOUtils.write((int)this.outputSymbols.size(), (OutputStream)stream);
        for (Symbol symbol : this.outputSymbols) {
            Symbol.serialize(symbol, stream);
        }
    }

    public static MergeSortNode deserialize(ByteBuffer byteBuffer) {
        OrderingScheme orderingScheme = OrderingScheme.deserialize(byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> outputSymbols = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            outputSymbols.add(Symbol.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new MergeSortNode(planNodeId, orderingScheme, outputSymbols);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((this.children.size() == newChildren.size() ? 1 : 0) != 0, (Object)"wrong number of new children");
        return new MergeSortNode(this.id, newChildren, this.orderingScheme, this.outputSymbols);
    }

    public OrderingScheme getOrderingScheme() {
        return this.orderingScheme;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MergeSortNode sortNode = (MergeSortNode)o;
        return Objects.equal((Object)this.orderingScheme, (Object)sortNode.orderingScheme) && Objects.equal(this.outputSymbols, sortNode.outputSymbols);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.orderingScheme, this.outputSymbols});
    }

    public String toString() {
        return "MergeSortNode-" + this.getPlanNodeId();
    }
}

