/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinScalarFunction;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.tsfile.read.common.type.Type;

public class SymbolAllocator {
    public static final String GROUP_KEY_SUFFIX = "gid";
    public static final String SEPARATOR = "$";
    public static final String DATE_BIN_PREFIX = TableBuiltinScalarFunction.DATE_BIN.getFunctionName() + "$";
    private final Map<Symbol, Type> symbolMap = new HashMap<Symbol, Type>();
    private int nextId;

    public Symbol newSymbol(Symbol symbolHint) {
        return this.newSymbol(symbolHint, null);
    }

    public Symbol newSymbol(Symbol symbolHint, String suffix) {
        Preconditions.checkArgument((boolean)this.symbolMap.containsKey(symbolHint), (Object)"symbolHint not in symbols map");
        return this.newSymbol(symbolHint.getName(), this.symbolMap.get(symbolHint), suffix);
    }

    public Symbol newSymbol(String symbolHint, Type type) {
        return this.newSymbol(symbolHint, type, null);
    }

    public Symbol newSymbol(String symbolHint, Type symbolType, String suffix) {
        Objects.requireNonNull(symbolHint, "symbolHint is null");
        Objects.requireNonNull(symbolType, "type is null");
        if (suffix != null) {
            symbolHint = symbolHint + SEPARATOR + suffix;
        }
        Symbol symbol = new Symbol(symbolHint);
        while (this.symbolMap.putIfAbsent(symbol, symbolType) != null) {
            symbol = new Symbol(symbolHint + "_" + this.nextId());
        }
        return symbol;
    }

    public Symbol newSymbol(Expression expression, Type type) {
        return this.newSymbol(expression, type, null);
    }

    public Symbol newSymbol(Expression expression, Type type, String suffix) {
        String nameHint = "expr";
        if (expression instanceof Identifier) {
            nameHint = ((Identifier)expression).getValue();
        } else if (expression instanceof FunctionCall) {
            nameHint = ((FunctionCall)expression).getName().getSuffix();
        } else if (expression instanceof SymbolReference) {
            nameHint = ((SymbolReference)expression).getName();
        }
        return this.newSymbol(nameHint, type, suffix);
    }

    public Symbol newSymbol(Field field) {
        String symbolHint = field.getName().orElse("field");
        return this.newSymbol(symbolHint, field.getType());
    }

    public TypeProvider getTypes() {
        return TypeProvider.viewOf(this.symbolMap);
    }

    private int nextId() {
        return this.nextId++;
    }
}

