/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class AddReferencesRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=492");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=494");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=493");
    private final RequestHeader requestHeader;
    private final AddReferencesItem[] referencesToAdd;

    public AddReferencesRequest(RequestHeader requestHeader, AddReferencesItem[] referencesToAdd) {
        this.requestHeader = requestHeader;
        this.referencesToAdd = referencesToAdd;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public AddReferencesItem[] getReferencesToAdd() {
        return this.referencesToAdd;
    }

    protected AddReferencesRequest(AddReferencesRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((AddReferencesRequestBuilder)b).requestHeader;
        this.referencesToAdd = ((AddReferencesRequestBuilder)b).referencesToAdd;
    }

    public static AddReferencesRequestBuilder<?, ?> builder() {
        return new AddReferencesRequestBuilderImpl();
    }

    public AddReferencesRequestBuilder<?, ?> toBuilder() {
        return new AddReferencesRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddReferencesRequest)) {
            return false;
        }
        AddReferencesRequest other = (AddReferencesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getReferencesToAdd(), other.getReferencesToAdd());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddReferencesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReferencesToAdd());
        return result;
    }

    @Override
    public String toString() {
        return "AddReferencesRequest(requestHeader=" + this.getRequestHeader() + ", referencesToAdd=" + Arrays.deepToString(this.getReferencesToAdd()) + ")";
    }

    private static final class AddReferencesRequestBuilderImpl
    extends AddReferencesRequestBuilder<AddReferencesRequest, AddReferencesRequestBuilderImpl> {
        private AddReferencesRequestBuilderImpl() {
        }

        @Override
        protected AddReferencesRequestBuilderImpl self() {
            return this;
        }

        @Override
        public AddReferencesRequest build() {
            return new AddReferencesRequest(this);
        }
    }

    public static abstract class AddReferencesRequestBuilder<C extends AddReferencesRequest, B extends AddReferencesRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private AddReferencesItem[] referencesToAdd;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AddReferencesRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AddReferencesRequest instance, AddReferencesRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.referencesToAdd(instance.referencesToAdd);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B referencesToAdd(AddReferencesItem[] referencesToAdd) {
            this.referencesToAdd = referencesToAdd;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AddReferencesRequest.AddReferencesRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", referencesToAdd=" + Arrays.deepToString(this.referencesToAdd) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AddReferencesRequest> {
        @Override
        public Class<AddReferencesRequest> getType() {
            return AddReferencesRequest.class;
        }

        @Override
        public AddReferencesRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            AddReferencesItem[] referencesToAdd = (AddReferencesItem[])decoder.readStructArray("ReferencesToAdd", AddReferencesItem.TYPE_ID);
            return new AddReferencesRequest(requestHeader, referencesToAdd);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AddReferencesRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStructArray("ReferencesToAdd", (Object[])value.getReferencesToAdd(), AddReferencesItem.TYPE_ID);
        }
    }
}

