/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

class H2PersistentQueue<T>
extends AbstractQueue<T> {
    private final MVMap<Long, T> queueMap;
    private final MVMap<String, Long> metadataMap;
    private final AtomicLong head;
    private final AtomicLong tail;

    H2PersistentQueue(MVStore store, String queueName) {
        if (queueName == null || queueName.isEmpty()) {
            throw new IllegalArgumentException("queueName parameter can't be empty or null");
        }
        this.queueMap = store.openMap("queue_" + queueName);
        this.metadataMap = store.openMap("queue_" + queueName + "_meta");
        long headIdx = 0L;
        if (this.metadataMap.containsKey((Object)"head")) {
            headIdx = (Long)this.metadataMap.get((Object)"head");
        } else {
            this.metadataMap.put((Object)"head", (Object)headIdx);
        }
        this.head = new AtomicLong(headIdx);
        long tailIdx = 0L;
        if (this.metadataMap.containsKey((Object)"tail")) {
            tailIdx = (Long)this.metadataMap.get((Object)"tail");
        } else {
            this.metadataMap.put((Object)"tail", (Object)tailIdx);
        }
        this.tail = new AtomicLong(tailIdx);
    }

    static void dropQueue(MVStore store, String queueName) {
        store.removeMap(store.openMap("queue_" + queueName));
        store.removeMap(store.openMap("queue_" + queueName + "_meta"));
    }

    @Override
    public Iterator<T> iterator() {
        return null;
    }

    @Override
    public int size() {
        return this.head.intValue() - this.tail.intValue();
    }

    @Override
    public boolean offer(T t) {
        if (t == null) {
            throw new NullPointerException("Inserted element can't be null");
        }
        long nextHead = this.head.getAndIncrement();
        this.queueMap.put((Object)nextHead, t);
        this.metadataMap.put((Object)"head", (Object)(nextHead + 1L));
        return true;
    }

    @Override
    public T poll() {
        if (this.head.equals(this.tail)) {
            return null;
        }
        long nextTail = this.tail.getAndIncrement();
        Object tail = this.queueMap.get((Object)nextTail);
        this.queueMap.remove((Object)nextTail);
        this.metadataMap.put((Object)"tail", (Object)(nextTail + 1L));
        return (T)tail;
    }

    @Override
    public T peek() {
        if (this.head.equals(this.tail)) {
            return null;
        }
        return (T)this.queueMap.get((Object)this.tail.get());
    }
}

