/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.config.ClusterDescriptor;

public class Timer {
    public static final boolean ENABLE_INSTRUMENTING = true;
    private static final String COORDINATOR = "Coordinator";
    private static final String META_GROUP_MEMBER = "Meta group member";
    private static final String DATA_GROUP_MEMBER = "Data group member";
    private static final String RAFT_MEMBER_SENDER = " Raft member(sender)";
    private static final String RAFT_MEMBER_RECEIVER = " Raft member(receiver)";
    private static final String LOG_DISPATCHER = "Log dispatcher";
    private static final double TIME_SCALE = 1000000.0;

    public static String getReport() {
        StringBuilder result = new StringBuilder();
        Timer.printTo(Statistic.ROOT, result);
        return result.toString();
    }

    private static void printTo(Statistic currNode, StringBuilder out) {
        if (currNode != Statistic.ROOT && currNode.valid) {
            Timer.indent(out, currNode.level);
            out.append((Object)currNode).append("\n");
        }
        for (Statistic child : currNode.children) {
            Timer.printTo(child, out);
        }
    }

    private static void indent(StringBuilder out, int indents) {
        for (int i = 0; i < indents; ++i) {
            out.append("  ");
        }
    }

    public static enum Statistic {
        ROOT("ClassName", "BlockName", 1000000.0, true, null),
        COORDINATOR_EXECUTE_NON_QUERY("Coordinator", "execute non query", 1000000.0, true, ROOT),
        META_GROUP_MEMBER_EXECUTE_NON_QUERY("Meta group member", "execute non query", 1000000.0, true, COORDINATOR_EXECUTE_NON_QUERY),
        META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_LOCAL_GROUP("Meta group member", "execute in local group", 1000000.0, true, META_GROUP_MEMBER_EXECUTE_NON_QUERY),
        META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_REMOTE_GROUP("Meta group member", "execute in remote group", 1000000.0, true, META_GROUP_MEMBER_EXECUTE_NON_QUERY),
        DATA_GROUP_MEMBER_LOCAL_EXECUTION("Data group member", "execute locally", 1000000.0, true, META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_LOCAL_GROUP),
        DATA_GROUP_MEMBER_WAIT_LEADER("Data group member", "wait for leader", 1000000.0, true, META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_LOCAL_GROUP),
        DATA_GROUP_MEMBER_FORWARD_PLAN("Data group member", "forward to leader", 1000000.0, true, META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_LOCAL_GROUP),
        RAFT_SENDER_APPEND_LOG(" Raft member(sender)", "locally append log", 1000000.0, true, DATA_GROUP_MEMBER_LOCAL_EXECUTION),
        RAFT_SENDER_COMPETE_LOG_MANAGER_BEFORE_APPEND_V2(" Raft member(sender)", "compete for log manager before append", 1000000.0, false, DATA_GROUP_MEMBER_LOCAL_EXECUTION),
        RAFT_SENDER_APPEND_LOG_V2(" Raft member(sender)", "locally append log", 1000000.0, false, DATA_GROUP_MEMBER_LOCAL_EXECUTION),
        RAFT_SENDER_BUILD_LOG_REQUEST(" Raft member(sender)", "build SendLogRequest", 1000000.0, false, DATA_GROUP_MEMBER_LOCAL_EXECUTION),
        RAFT_SENDER_BUILD_APPEND_REQUEST(" Raft member(sender)", "build AppendEntryRequest", 1000000.0, false, RAFT_SENDER_BUILD_LOG_REQUEST),
        RAFT_SENDER_OFFER_LOG(" Raft member(sender)", "offer log to dispatcher", 1000000.0, false, DATA_GROUP_MEMBER_LOCAL_EXECUTION),
        RAFT_SENDER_SEND_LOG_TO_FOLLOWERS(" Raft member(sender)", "send log to followers", 1000000.0, true, DATA_GROUP_MEMBER_LOCAL_EXECUTION),
        RAFT_SENDER_WAIT_FOR_PREV_LOG(" Raft member(sender)", "sender wait for prev log", 1000000.0, true, RAFT_SENDER_SEND_LOG_TO_FOLLOWERS),
        RAFT_SENDER_SERIALIZE_LOG(" Raft member(sender)", "serialize logs", 1000000.0, true, RAFT_SENDER_SEND_LOG_TO_FOLLOWERS),
        RAFT_SENDER_SEND_LOG_ASYNC(" Raft member(sender)", "send log async", 1000000.0, ClusterDescriptor.getInstance().getConfig().isUseAsyncServer(), RAFT_SENDER_SEND_LOG_TO_FOLLOWERS),
        RAFT_SENDER_SEND_LOG(" Raft member(sender)", "send log", 1000000.0, true, RAFT_SENDER_SEND_LOG_TO_FOLLOWERS),
        RAFT_SENDER_VOTE_COUNTER(" Raft member(sender)", "wait for votes", 1000000.0, true, RAFT_SENDER_SEND_LOG_TO_FOLLOWERS),
        RAFT_SENDER_COMMIT_LOG(" Raft member(sender)", "locally commit log", 1000000.0, true, DATA_GROUP_MEMBER_LOCAL_EXECUTION),
        RAFT_SENDER_COMPETE_LOG_MANAGER_BEFORE_COMMIT(" Raft member(sender)", "compete for log manager before commit", 1000000.0, true, RAFT_SENDER_COMMIT_LOG),
        RAFT_SENDER_COMMIT_LOG_IN_MANAGER(" Raft member(sender)", "commit log in log manager", 1000000.0, false, RAFT_SENDER_COMMIT_LOG),
        RAFT_SENDER_COMMIT_GET_LOGS(" Raft member(sender)", "get logs to be committed", 1000000.0, false, RAFT_SENDER_COMMIT_LOG_IN_MANAGER),
        RAFT_SENDER_COMMIT_DELETE_EXCEEDING_LOGS(" Raft member(sender)", "delete logs exceeding capacity", 1000000.0, false, RAFT_SENDER_COMMIT_LOG_IN_MANAGER),
        RAFT_SENDER_COMMIT_APPEND_AND_STABLE_LOGS(" Raft member(sender)", "append and stable committed logs", 1000000.0, false, RAFT_SENDER_COMMIT_LOG_IN_MANAGER),
        RAFT_SENDER_COMMIT_APPLY_LOGS(" Raft member(sender)", "apply after committing logs", 1000000.0, false, RAFT_SENDER_COMMIT_LOG_IN_MANAGER),
        RAFT_SENDER_COMMIT_TO_CONSUMER_LOGS(" Raft member(sender)", "provide log to consumer", 1000000.0, false, RAFT_SENDER_COMMIT_APPLY_LOGS),
        RAFT_SENDER_COMMIT_EXCLUSIVE_LOGS(" Raft member(sender)", "apply logs that cannot run in parallel", 1000000.0, false, RAFT_SENDER_COMMIT_APPLY_LOGS),
        RAFT_SENDER_COMMIT_WAIT_LOG_APPLY(" Raft member(sender)", "wait until log is applied", 1000000.0, true, RAFT_SENDER_COMMIT_LOG),
        RAFT_SENDER_IN_APPLY_QUEUE(" Raft member(sender)", "in apply queue", 1000000.0, true, RAFT_SENDER_COMMIT_WAIT_LOG_APPLY),
        RAFT_SENDER_DATA_LOG_APPLY(" Raft member(sender)", "apply data log", 1000000.0, true, RAFT_SENDER_COMMIT_WAIT_LOG_APPLY),
        RAFT_SENDER_LOG_FROM_CREATE_TO_ACCEPT(" Raft member(sender)", "log from create to accept", 1000000.0, false, DATA_GROUP_MEMBER_LOCAL_EXECUTION),
        RAFT_RECEIVER_LOG_PARSE(" Raft member(receiver)", "log parse", 1000000.0, true, RAFT_SENDER_SEND_LOG_TO_FOLLOWERS),
        RAFT_RECEIVER_WAIT_FOR_PREV_LOG(" Raft member(receiver)", "receiver wait for prev log", 1000000.0, true, RAFT_SENDER_SEND_LOG_TO_FOLLOWERS),
        RAFT_RECEIVER_APPEND_ENTRY(" Raft member(receiver)", "append entrys", 1000000.0, true, RAFT_SENDER_SEND_LOG_TO_FOLLOWERS),
        RAFT_RECEIVER_INDEX_DIFF(" Raft member(receiver)", "index diff", 1.0, true, ROOT),
        LOG_DISPATCHER_LOG_IN_QUEUE("Log dispatcher", "in queue", 1000000.0, true, META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_LOCAL_GROUP),
        LOG_DISPATCHER_FROM_CREATE_TO_END("Log dispatcher", "from create to end", 1000000.0, true, META_GROUP_MEMBER_EXECUTE_NON_QUERY_IN_LOCAL_GROUP);

        String className;
        String blockName;
        AtomicLong sum = new AtomicLong(0L);
        AtomicLong counter = new AtomicLong(0L);
        double scale;
        boolean valid;
        int level;
        Statistic parent;
        List<Statistic> children = new ArrayList<Statistic>();

        private Statistic(String className, String blockName, double scale, boolean valid, Statistic parent) {
            this.className = className;
            this.blockName = blockName;
            this.scale = scale;
            this.valid = valid;
            this.parent = parent;
            if (parent == null) {
                this.level = -1;
            } else {
                this.level = parent.level + 1;
                parent.children.add(this);
            }
        }

        public void add(long val) {
            this.sum.addAndGet(val);
            this.counter.incrementAndGet();
        }

        public long getOperationStartTime() {
            return System.nanoTime();
        }

        public void calOperationCostTimeFromStart(long startTime) {
            if (startTime != Long.MIN_VALUE) {
                this.add(System.nanoTime() - startTime);
            }
        }

        public void reset() {
            this.sum.set(0L);
            this.counter.set(0L);
        }

        public static void resetAll() {
            for (Statistic value : Statistic.values()) {
                value.reset();
            }
        }

        public String toString() {
            double s = (double)this.sum.get() / this.scale;
            long cnt = this.counter.get();
            double avg = s / (double)cnt;
            return String.format("%s - %s: %.2f, %d, %.2f", this.className, this.blockName, s, cnt, avg);
        }
    }
}

