/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MultiMap<K extends Comparable<? super K>, V> {
    private final Comparator<? super Map.Entry<V, K>> comparator = new EntryComparator();
    private final Map<K, List<V>> data = new HashMap<K, List<V>>();
    private final Map<V, K> inverse = new HashMap<V, K>();

    public void clear() {
        this.data.clear();
        this.inverse.clear();
    }

    public Collection<Map.Entry<V, K>> entries() {
        ArrayList<Map.Entry<V, K>> list2 = new ArrayList<Map.Entry<V, K>>(this.inverse.entrySet());
        Collections.sort(list2, this.comparator);
        return list2;
    }

    public Collection<V> values() {
        return this.inverse.keySet();
    }

    public V find(V copy2) {
        Comparable key = (Comparable)this.inverse.get(copy2);
        if (key != null) {
            List<V> list2 = this.data.get(key);
            return list2.get(list2.indexOf(copy2));
        }
        return null;
    }

    public boolean hasValues(K key) {
        List<V> list2 = this.data.get(key);
        if (list2 == null) {
            return false;
        }
        return !list2.isEmpty();
    }

    public boolean isEmpty() {
        return this.inverse.isEmpty();
    }

    private List<V> getValues(K key) {
        List<V> list2 = this.data.get(key);
        if (list2 == null) {
            list2 = new ArrayList<V>();
            this.data.put(key, list2);
        }
        return list2;
    }

    public boolean insert(K key, V value2) {
        boolean inserted;
        Comparable old = (Comparable)this.inverse.get(value2);
        if (old != null) {
            this.removeData(old, value2);
        }
        if (inserted = this.getValues(key).add(value2)) {
            this.inverse.put(value2, key);
        }
        return inserted;
    }

    public Collection<V> remove(K key) {
        List<V> removed = this.data.remove(key);
        if (removed != null) {
            for (V val : removed) {
                this.inverse.remove(val);
            }
        }
        return removed;
    }

    public boolean remove(V value2) {
        Comparable key = (Comparable)this.inverse.remove(value2);
        if (key != null) {
            return this.removeData(key, value2);
        }
        return false;
    }

    public boolean remove(K key, V value2) {
        boolean removed = this.removeData(key, value2);
        if (removed) {
            this.inverse.remove(value2);
        }
        return removed;
    }

    private boolean removeData(K key, V value2) {
        boolean removed = false;
        List<V> list2 = this.data.get(key);
        if (list2 != null) {
            removed = list2.remove(value2);
            if (list2.isEmpty()) {
                this.data.remove(key);
            }
        }
        return removed;
    }

    public String toString() {
        return this.data.toString();
    }

    private final class EntryComparator
    implements Comparator<Map.Entry<V, K>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<V, K> first2, Map.Entry<V, K> second2) {
            return ((Comparable)first2.getValue()).compareTo(second2.getValue());
        }
    }
}

