/*
 * Decompiled with CFR 0.152.
 */
package zmq.io;

import java.nio.channels.SelectableChannel;
import zmq.io.IOThread;
import zmq.poll.IPollEvents;
import zmq.poll.Poller;

public class IOObject
implements IPollEvents {
    private final Poller poller;
    private final IPollEvents handler;
    private boolean alive;

    public IOObject(IOThread ioThread, IPollEvents handler) {
        assert (ioThread != null);
        assert (handler != null);
        this.handler = handler;
        this.poller = ioThread.getPoller();
    }

    public final void plug() {
        this.alive = true;
    }

    public final void unplug() {
        this.alive = false;
    }

    public final Poller.Handle addFd(SelectableChannel fd) {
        return this.poller.addHandle(fd, this);
    }

    public final void removeHandle(Poller.Handle handle2) {
        this.poller.removeHandle(handle2);
    }

    public final void setPollIn(Poller.Handle handle2) {
        this.poller.setPollIn(handle2);
    }

    public final void setPollOut(Poller.Handle handle2) {
        this.poller.setPollOut(handle2);
    }

    public final void setPollConnect(Poller.Handle handle2) {
        this.poller.setPollConnect(handle2);
    }

    public final void setPollAccept(Poller.Handle handle2) {
        this.poller.setPollAccept(handle2);
    }

    public final void resetPollIn(Poller.Handle handle2) {
        this.poller.resetPollIn(handle2);
    }

    public final void resetPollOut(Poller.Handle handle2) {
        this.poller.resetPollOut(handle2);
    }

    @Override
    public final void inEvent() {
        assert (this.alive);
        this.handler.inEvent();
    }

    @Override
    public final void outEvent() {
        assert (this.alive);
        this.handler.outEvent();
    }

    @Override
    public final void connectEvent() {
        assert (this.alive);
        this.handler.connectEvent();
    }

    @Override
    public final void acceptEvent() {
        assert (this.alive);
        this.handler.acceptEvent();
    }

    @Override
    public final void timerEvent(int id2) {
        assert (this.alive);
        this.handler.timerEvent(id2);
    }

    public final void addTimer(long timeout, int id2) {
        assert (this.alive);
        this.poller.addTimer(timeout, this, id2);
    }

    public final void cancelTimer(int id2) {
        assert (this.alive);
        this.poller.cancelTimer(this, id2);
    }

    public String toString() {
        return "" + this.handler;
    }
}

