/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class StreamUtils {
    public static final int BUFFER_SIZE = 4096;
    private static final byte[] EMPTY_CONTENT = new byte[0];

    public static byte[] copyToByteArray(@Nullable InputStream in2) throws IOException {
        if (in2 == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(4096);
        StreamUtils.copy(in2, (OutputStream)out2);
        return out2.toByteArray();
    }

    public static String copyToString(@Nullable InputStream in2, Charset charset) throws IOException {
        if (in2 == null) {
            return "";
        }
        StringBuilder out2 = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in2, charset);
        char[] buffer2 = new char[4096];
        int bytesRead = -1;
        while ((bytesRead = reader.read(buffer2)) != -1) {
            out2.append(buffer2, 0, bytesRead);
        }
        return out2.toString();
    }

    public static void copy(byte[] in2, OutputStream out2) throws IOException {
        Assert.notNull((Object)in2, "No input byte array specified");
        Assert.notNull((Object)out2, "No OutputStream specified");
        out2.write(in2);
    }

    public static void copy(String in2, Charset charset, OutputStream out2) throws IOException {
        Assert.notNull((Object)in2, "No input String specified");
        Assert.notNull((Object)charset, "No charset specified");
        Assert.notNull((Object)out2, "No OutputStream specified");
        OutputStreamWriter writer2 = new OutputStreamWriter(out2, charset);
        writer2.write(in2);
        ((Writer)writer2).flush();
    }

    public static int copy(InputStream in2, OutputStream out2) throws IOException {
        Assert.notNull((Object)in2, "No InputStream specified");
        Assert.notNull((Object)out2, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer2 = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = in2.read(buffer2)) != -1) {
            out2.write(buffer2, 0, bytesRead);
            byteCount += bytesRead;
        }
        out2.flush();
        return byteCount;
    }

    public static long copyRange(InputStream in2, OutputStream out2, long start2, long end2) throws IOException {
        int bytesRead;
        Assert.notNull((Object)in2, "No InputStream specified");
        Assert.notNull((Object)out2, "No OutputStream specified");
        long skipped = in2.skip(start2);
        if (skipped < start2) {
            throw new IOException("Skipped only " + skipped + " bytes out of " + start2 + " required");
        }
        long bytesToCopy = end2 - start2 + 1L;
        byte[] buffer2 = new byte[4096];
        while (bytesToCopy > 0L && (bytesRead = in2.read(buffer2)) != -1) {
            if ((long)bytesRead <= bytesToCopy) {
                out2.write(buffer2, 0, bytesRead);
                bytesToCopy -= (long)bytesRead;
                continue;
            }
            out2.write(buffer2, 0, (int)bytesToCopy);
            bytesToCopy = 0L;
        }
        return end2 - start2 + 1L - bytesToCopy;
    }

    public static int drain(InputStream in2) throws IOException {
        Assert.notNull((Object)in2, "No InputStream specified");
        byte[] buffer2 = new byte[4096];
        int bytesRead = -1;
        int byteCount = 0;
        while ((bytesRead = in2.read(buffer2)) != -1) {
            byteCount += bytesRead;
        }
        return byteCount;
    }

    public static InputStream emptyInput() {
        return new ByteArrayInputStream(EMPTY_CONTENT);
    }

    public static InputStream nonClosing(InputStream in2) {
        Assert.notNull((Object)in2, "No InputStream specified");
        return new NonClosingInputStream(in2);
    }

    public static OutputStream nonClosing(OutputStream out2) {
        Assert.notNull((Object)out2, "No OutputStream specified");
        return new NonClosingOutputStream(out2);
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        public NonClosingOutputStream(OutputStream out2) {
            super(out2);
        }

        @Override
        public void write(byte[] b2, int off, int let) throws IOException {
            this.out.write(b2, off, let);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream in2) {
            super(in2);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

