/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.LinkedList;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.UpdateMessageDigestInputStream;

public class FastByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_BLOCK_SIZE = 256;
    private final LinkedList<byte[]> buffers = new LinkedList();
    private final int initialBlockSize;
    private int nextBlockSize = 0;
    private int alreadyBufferedSize = 0;
    private int index = 0;
    private boolean closed = false;

    public FastByteArrayOutputStream() {
        this(256);
    }

    public FastByteArrayOutputStream(int initialBlockSize) {
        Assert.isTrue(initialBlockSize > 0, "Initial block size must be greater than 0");
        this.initialBlockSize = initialBlockSize;
        this.nextBlockSize = initialBlockSize;
    }

    @Override
    public void write(int datum) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.buffers.peekLast() == null || this.buffers.getLast().length == this.index) {
            this.addBuffer(1);
        }
        this.buffers.getLast()[this.index++] = (byte)datum;
    }

    @Override
    public void write(byte[] data, int offset, int length2) throws IOException {
        if (offset < 0 || offset + length2 > data.length || length2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.buffers.peekLast() == null || this.buffers.getLast().length == this.index) {
            this.addBuffer(length2);
        }
        if (this.index + length2 > this.buffers.getLast().length) {
            int copyLength;
            int pos = offset;
            do {
                if (this.index == this.buffers.getLast().length) {
                    this.addBuffer(length2);
                }
                if (length2 < (copyLength = this.buffers.getLast().length - this.index)) {
                    copyLength = length2;
                }
                System.arraycopy(data, pos, this.buffers.getLast(), this.index, copyLength);
                pos += copyLength;
                this.index += copyLength;
            } while ((length2 -= copyLength) > 0);
        } else {
            System.arraycopy(data, offset, this.buffers.getLast(), this.index, length2);
            this.index += length2;
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String toString() {
        return new String(this.toByteArrayUnsafe());
    }

    public int size() {
        return this.alreadyBufferedSize + this.index;
    }

    public byte[] toByteArrayUnsafe() {
        int totalSize = this.size();
        if (totalSize == 0) {
            return new byte[0];
        }
        this.resize(totalSize);
        return this.buffers.getFirst();
    }

    public byte[] toByteArray() {
        byte[] bytesUnsafe = this.toByteArrayUnsafe();
        return (byte[])bytesUnsafe.clone();
    }

    public void reset() {
        this.buffers.clear();
        this.nextBlockSize = this.initialBlockSize;
        this.closed = false;
        this.index = 0;
        this.alreadyBufferedSize = 0;
    }

    public InputStream getInputStream() {
        return new FastByteArrayInputStream(this);
    }

    public void writeTo(OutputStream out2) throws IOException {
        Iterator it = this.buffers.iterator();
        while (it.hasNext()) {
            byte[] bytes = (byte[])it.next();
            if (it.hasNext()) {
                out2.write(bytes, 0, bytes.length);
                continue;
            }
            out2.write(bytes, 0, this.index);
        }
    }

    public void resize(int targetCapacity) {
        Assert.isTrue(targetCapacity >= this.size(), "New capacity must not be smaller than current size");
        if (this.buffers.peekFirst() == null) {
            this.nextBlockSize = targetCapacity - this.size();
        } else if (this.size() != targetCapacity || this.buffers.getFirst().length != targetCapacity) {
            int totalSize = this.size();
            byte[] data = new byte[targetCapacity];
            int pos = 0;
            Iterator it = this.buffers.iterator();
            while (it.hasNext()) {
                byte[] bytes = (byte[])it.next();
                if (it.hasNext()) {
                    System.arraycopy(bytes, 0, data, pos, bytes.length);
                    pos += bytes.length;
                    continue;
                }
                System.arraycopy(bytes, 0, data, pos, this.index);
            }
            this.buffers.clear();
            this.buffers.add(data);
            this.index = totalSize;
            this.alreadyBufferedSize = 0;
        }
    }

    private void addBuffer(int minCapacity) {
        if (this.buffers.peekLast() != null) {
            this.alreadyBufferedSize += this.index;
            this.index = 0;
        }
        if (this.nextBlockSize < minCapacity) {
            this.nextBlockSize = FastByteArrayOutputStream.nextPowerOf2(minCapacity);
        }
        this.buffers.add(new byte[this.nextBlockSize]);
        this.nextBlockSize *= 2;
    }

    private static int nextPowerOf2(int val) {
        --val;
        val = val >> 1 | val;
        val = val >> 2 | val;
        val = val >> 4 | val;
        val = val >> 8 | val;
        val = val >> 16 | val;
        return ++val;
    }

    private static final class FastByteArrayInputStream
    extends UpdateMessageDigestInputStream {
        private final FastByteArrayOutputStream fastByteArrayOutputStream;
        private final Iterator<byte[]> buffersIterator;
        @Nullable
        private byte[] currentBuffer;
        private int currentBufferLength = 0;
        private int nextIndexInCurrentBuffer = 0;
        private int totalBytesRead = 0;

        public FastByteArrayInputStream(FastByteArrayOutputStream fastByteArrayOutputStream) {
            this.fastByteArrayOutputStream = fastByteArrayOutputStream;
            this.buffersIterator = fastByteArrayOutputStream.buffers.iterator();
            if (this.buffersIterator.hasNext()) {
                this.currentBuffer = this.buffersIterator.next();
                this.currentBufferLength = this.currentBuffer == fastByteArrayOutputStream.buffers.getLast() ? fastByteArrayOutputStream.index : (this.currentBuffer != null ? this.currentBuffer.length : 0);
            }
        }

        @Override
        public int read() {
            if (this.currentBuffer == null) {
                return -1;
            }
            if (this.nextIndexInCurrentBuffer < this.currentBufferLength) {
                ++this.totalBytesRead;
                return this.currentBuffer[this.nextIndexInCurrentBuffer++] & 0xFF;
            }
            if (this.buffersIterator.hasNext()) {
                this.currentBuffer = this.buffersIterator.next();
                this.updateCurrentBufferLength();
                this.nextIndexInCurrentBuffer = 0;
            } else {
                this.currentBuffer = null;
            }
            return this.read();
        }

        @Override
        public int read(byte[] b2) {
            return this.read(b2, 0, b2.length);
        }

        @Override
        public int read(byte[] b2, int off, int len2) {
            if (off < 0 || len2 < 0 || len2 > b2.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len2 == 0) {
                return 0;
            }
            if (this.currentBuffer == null) {
                return -1;
            }
            if (this.nextIndexInCurrentBuffer < this.currentBufferLength) {
                int bytesToCopy = Math.min(len2, this.currentBufferLength - this.nextIndexInCurrentBuffer);
                System.arraycopy(this.currentBuffer, this.nextIndexInCurrentBuffer, b2, off, bytesToCopy);
                this.totalBytesRead += bytesToCopy;
                this.nextIndexInCurrentBuffer += bytesToCopy;
                int remaining = this.read(b2, off + bytesToCopy, len2 - bytesToCopy);
                return bytesToCopy + Math.max(remaining, 0);
            }
            if (this.buffersIterator.hasNext()) {
                this.currentBuffer = this.buffersIterator.next();
                this.updateCurrentBufferLength();
                this.nextIndexInCurrentBuffer = 0;
            } else {
                this.currentBuffer = null;
            }
            return this.read(b2, off, len2);
        }

        @Override
        public long skip(long n) throws IOException {
            if (n > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("n exceeds maximum (2147483647): " + n);
            }
            if (n == 0L) {
                return 0L;
            }
            if (n < 0L) {
                throw new IllegalArgumentException("n must be 0 or greater: " + n);
            }
            int len2 = (int)n;
            if (this.currentBuffer == null) {
                return 0L;
            }
            if (this.nextIndexInCurrentBuffer < this.currentBufferLength) {
                int bytesToSkip = Math.min(len2, this.currentBufferLength - this.nextIndexInCurrentBuffer);
                this.totalBytesRead += bytesToSkip;
                this.nextIndexInCurrentBuffer += bytesToSkip;
                return (long)bytesToSkip + this.skip(len2 - bytesToSkip);
            }
            if (this.buffersIterator.hasNext()) {
                this.currentBuffer = this.buffersIterator.next();
                this.updateCurrentBufferLength();
                this.nextIndexInCurrentBuffer = 0;
            } else {
                this.currentBuffer = null;
            }
            return this.skip(len2);
        }

        @Override
        public int available() {
            return this.fastByteArrayOutputStream.size() - this.totalBytesRead;
        }

        @Override
        public void updateMessageDigest(MessageDigest messageDigest) {
            this.updateMessageDigest(messageDigest, this.available());
        }

        @Override
        public void updateMessageDigest(MessageDigest messageDigest, int len2) {
            if (this.currentBuffer == null) {
                return;
            }
            if (len2 == 0) {
                return;
            }
            if (len2 < 0) {
                throw new IllegalArgumentException("len must be 0 or greater: " + len2);
            }
            if (this.nextIndexInCurrentBuffer < this.currentBufferLength) {
                int bytesToCopy = Math.min(len2, this.currentBufferLength - this.nextIndexInCurrentBuffer);
                messageDigest.update(this.currentBuffer, this.nextIndexInCurrentBuffer, bytesToCopy);
                this.nextIndexInCurrentBuffer += bytesToCopy;
                this.updateMessageDigest(messageDigest, len2 - bytesToCopy);
            } else {
                if (this.buffersIterator.hasNext()) {
                    this.currentBuffer = this.buffersIterator.next();
                    this.updateCurrentBufferLength();
                    this.nextIndexInCurrentBuffer = 0;
                } else {
                    this.currentBuffer = null;
                }
                this.updateMessageDigest(messageDigest, len2);
            }
        }

        private void updateCurrentBufferLength() {
            this.currentBufferLength = this.currentBuffer == this.fastByteArrayOutputStream.buffers.getLast() ? this.fastByteArrayOutputStream.index : (this.currentBuffer != null ? this.currentBuffer.length : 0);
        }
    }
}

