/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.kernel.protocol.v5.client.boot.layers;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import com.typesafe.config.Config;
import org.apache.toree.comm.CommRegistrar;
import org.apache.toree.comm.CommRegistrar$;
import org.apache.toree.comm.CommStorage;
import org.apache.toree.comm.CommStorage$;
import org.apache.toree.communication.security.SignatureManagerActor;
import org.apache.toree.communication.security.package$SecurityActorType$;
import org.apache.toree.kernel.protocol.v5.client.ActorLoader;
import org.apache.toree.kernel.protocol.v5.client.boot.layers.StandardSystemInitialization;
import org.apache.toree.kernel.protocol.v5.client.socket.HeartbeatClient;
import org.apache.toree.kernel.protocol.v5.client.socket.IOPubClient;
import org.apache.toree.kernel.protocol.v5.client.socket.ShellClient;
import org.apache.toree.kernel.protocol.v5.client.socket.SocketFactory;
import org.apache.toree.kernel.protocol.v5.client.socket.StdinClient;
import org.apache.toree.kernel.protocol.v5.package$SocketType$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public abstract class StandardSystemInitialization$class {
    public static Tuple6 initializeSystem(StandardSystemInitialization $this, Config config, ActorSystem actorSystem, ActorLoader actorLoader, SocketFactory socketFactory) {
        CommStorage commStorage = new CommStorage(CommStorage$.MODULE$.$lessinit$greater$default$1(), CommStorage$.MODULE$.$lessinit$greater$default$2());
        CommRegistrar commRegistrar = new CommRegistrar(commStorage, CommRegistrar$.MODULE$.$lessinit$greater$default$2());
        Tuple4 tuple42 = StandardSystemInitialization$class.initializeSystemActors($this, config, actorSystem, actorLoader, socketFactory, commRegistrar, commStorage);
        if (tuple42 != null) {
            Tuple4 tuple43;
            ActorRef heartbeat2 = (ActorRef)tuple42._1();
            ActorRef stdin = (ActorRef)tuple42._2();
            ActorRef shell = (ActorRef)tuple42._3();
            ActorRef ioPub = (ActorRef)tuple42._4();
            Tuple4 tuple44 = tuple43 = new Tuple4((Object)heartbeat2, (Object)stdin, (Object)shell, (Object)ioPub);
            ActorRef heartbeat3 = (ActorRef)tuple44._1();
            ActorRef stdin2 = (ActorRef)tuple44._2();
            ActorRef shell2 = (ActorRef)tuple44._3();
            ActorRef ioPub2 = (ActorRef)tuple44._4();
            Option signatureManager = StandardSystemInitialization$class.initializeSecurityActors($this, config, actorSystem);
            return new Tuple6((Object)heartbeat3, (Object)stdin2, (Object)shell2, (Object)ioPub2, (Object)commRegistrar, (Object)commStorage);
        }
        throw new MatchError((Object)tuple42);
    }

    private static Tuple4 initializeSystemActors(StandardSystemInitialization $this, Config config, ActorSystem actorSystem, ActorLoader actorLoader, SocketFactory socketFactory, CommRegistrar commRegistrar, CommStorage commStorage) {
        boolean signatureEnabled = new StringOps(Predef$.MODULE$.augmentString(config.getString("key"))).nonEmpty();
        ActorRef heartbeatClient = actorSystem.actorOf(Props$.MODULE$.apply(HeartbeatClient.class, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketFactory, actorLoader, BoxesRunTime.boxToBoolean((boolean)signatureEnabled)})), package$SocketType$.MODULE$.HeartbeatClient().toString());
        ActorRef stdinClient = actorSystem.actorOf(Props$.MODULE$.apply(StdinClient.class, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketFactory, actorLoader, BoxesRunTime.boxToBoolean((boolean)signatureEnabled)})), package$SocketType$.MODULE$.StdInClient().toString());
        ActorRef shellClient = actorSystem.actorOf(Props$.MODULE$.apply(ShellClient.class, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketFactory, actorLoader, BoxesRunTime.boxToBoolean((boolean)signatureEnabled)})), package$SocketType$.MODULE$.ShellClient().toString());
        ActorRef ioPubClient = actorSystem.actorOf(Props$.MODULE$.apply(IOPubClient.class, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketFactory, actorLoader, BoxesRunTime.boxToBoolean((boolean)signatureEnabled), commRegistrar, commStorage})), package$SocketType$.MODULE$.IOPubClient().toString());
        return new Tuple4((Object)heartbeatClient, (Object)stdinClient, (Object)shellClient, (Object)ioPubClient);
    }

    private static Option initializeSecurityActors(StandardSystemInitialization $this, Config config, ActorSystem actorSystem) {
        String key = config.getString("key");
        String signatureScheme = config.getString("signature_scheme").replace("-", "");
        None$ signatureManager = None$.MODULE$;
        if (new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty()) {
            $this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing client signatures with key '", "'!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
            signatureManager = new Some((Object)actorSystem.actorOf(Props$.MODULE$.apply(SignatureManagerActor.class, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, signatureScheme})), package$SecurityActorType$.MODULE$.SignatureManager().toString()));
        } else {
            $this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Signatures disabled for client!"})).s((Seq)Nil$.MODULE$));
        }
        return signatureManager;
    }

    public static void $init$(StandardSystemInitialization $this) {
    }
}

