/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.List;
import joptsimple.IllegalOptionSpecificationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParserRules {
    static final char HYPHEN_CHAR = '-';
    static final String HYPHEN = String.valueOf('-');
    static final String DOUBLE_HYPHEN = "--";
    static final String OPTION_TERMINATOR = "--";
    static final String RESERVED_FOR_EXTENSIONS = "W";

    private ParserRules() {
        throw new UnsupportedOperationException();
    }

    static boolean isShortOptionToken(String argument) {
        return argument.startsWith(HYPHEN) && !HYPHEN.equals(argument) && !ParserRules.isLongOptionToken(argument);
    }

    static boolean isLongOptionToken(String argument) {
        return argument.startsWith("--") && !ParserRules.isOptionTerminator(argument);
    }

    static boolean isOptionTerminator(String argument) {
        return "--".equals(argument);
    }

    static void ensureLegalOption(String option2) {
        if (option2.startsWith(HYPHEN)) {
            throw new IllegalOptionSpecificationException(String.valueOf(option2));
        }
        for (int i = 0; i < option2.length(); ++i) {
            ParserRules.ensureLegalOptionCharacter(option2.charAt(i));
        }
    }

    static void ensureLegalOptions(List<String> options2) {
        for (String each : options2) {
            ParserRules.ensureLegalOption(each);
        }
    }

    private static void ensureLegalOptionCharacter(char option2) {
        if (!Character.isLetterOrDigit(option2) && !ParserRules.isAllowedPunctuation(option2)) {
            throw new IllegalOptionSpecificationException(String.valueOf(option2));
        }
    }

    private static boolean isAllowedPunctuation(char option2) {
        String allowedPunctuation = "?._-";
        return allowedPunctuation.indexOf(option2) != -1;
    }
}

