/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

plugins {
  alias(libs.plugins.quarkus)
  id("org.kordamp.gradle.jandex")
  alias(libs.plugins.openapi.generator)
  id("polaris-runtime")
  // id("polaris-license-report")
}

dependencies {
  implementation(project(":polaris-core"))
  implementation(project(":polaris-version"))
  implementation(project(":polaris-api-management-service"))
  implementation(project(":polaris-api-iceberg-service"))

  compileOnly("com.fasterxml.jackson.core:jackson-annotations")

  runtimeOnly(project(":polaris-eclipselink"))
  runtimeOnly(project(":polaris-relational-jdbc"))
  runtimeOnly("org.postgresql:postgresql")

  implementation("io.quarkus:quarkus-jdbc-postgresql")
  implementation(enforcedPlatform(libs.quarkus.bom))
  implementation("io.quarkus:quarkus-picocli")
  implementation("io.quarkus:quarkus-container-image-docker")

  implementation(project(":polaris-runtime-common"))

  testImplementation(project(":polaris-runtime-test-common"))
  testFixturesApi(project(":polaris-core"))

  testFixturesApi(enforcedPlatform(libs.quarkus.bom))
  testFixturesApi("io.quarkus:quarkus-junit5")

  testFixturesApi(project(":polaris-container-spec-helper"))
  testFixturesApi(platform(libs.testcontainers.bom))
  testFixturesApi("org.testcontainers:testcontainers")
  testFixturesApi("org.testcontainers:postgresql")

  testRuntimeOnly(project(":polaris-eclipselink"))
  testRuntimeOnly("org.postgresql:postgresql")
}

quarkus {
  quarkusBuildProperties.put("quarkus.package.type", "fast-jar")
  // Pull manifest attributes from the "main" `jar` task to get the
  // release-information into the jars generated by Quarkus.
  quarkusBuildProperties.putAll(
    provider {
      tasks
        .named("jar", Jar::class.java)
        .get()
        .manifest
        .attributes
        .map { e -> "quarkus.package.jar.manifest.attributes.\"${e.key}\"" to e.value.toString() }
        .toMap()
    }
  )
}

// Configuration to expose distribution artifacts
val distributionElements by
  configurations.creating {
    isCanBeConsumed = true
    isCanBeResolved = false
  }

// Register the quarkus app directory as an artifact
artifacts {
  add("distributionElements", layout.buildDirectory.dir("quarkus-app")) { builtBy("quarkusBuild") }
}

tasks.withType(Test::class.java).configureEach {
  maxParallelForks = 4
  forkEvery = 1
}

tasks.named<Test>("test").configure {
  // enlarge the max heap size to avoid out of memory error
  maxHeapSize = "4g"
  // Silence the 'OpenJDK 64-Bit Server VM warning: Sharing is only supported for boot loader
  // classes because bootstrap classpath has been appended' warning from OpenJDK.
  jvmArgs("-Xshare:off")
}
