/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.defragmentation;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.IgniteDefragmentation;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.defragmentation.VisorDefragmentationOperation;
import org.apache.ignite.internal.visor.defragmentation.VisorDefragmentationTaskArg;
import org.apache.ignite.internal.visor.defragmentation.VisorDefragmentationTaskResult;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class VisorDefragmentationTask
extends VisorMultiNodeTask<VisorDefragmentationTaskArg, VisorDefragmentationTaskResult, VisorDefragmentationTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorDefragmentationTaskArg, VisorDefragmentationTaskResult> job(VisorDefragmentationTaskArg arg) {
        return new VisorDefragmentationJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected VisorDefragmentationTaskResult reduce0(List<ComputeJobResult> results) {
        if (((VisorDefragmentationTaskArg)this.taskArg).operation() == VisorDefragmentationOperation.SCHEDULE) {
            StringBuilder msg = new StringBuilder();
            for (ComputeJobResult res : results) {
                msg.append(res.getNode().consistentId()).append(":\n");
                if (res.getData() == null) {
                    msg.append("    err=").append(res.getException()).append('\n');
                    continue;
                }
                VisorDefragmentationTaskResult data = (VisorDefragmentationTaskResult)res.getData();
                msg.append("    success=").append(data.isSuccess()).append('\n');
                msg.append("    msg=").append(data.getMessage()).append('\n');
            }
            return new VisorDefragmentationTaskResult(true, msg.toString());
        }
        assert (results.size() == 1);
        ComputeJobResult res = results.get(0);
        if (res.getException() == null) {
            return (VisorDefragmentationTaskResult)res.getData();
        }
        throw res.getException();
    }

    private static class VisorDefragmentationJob
    extends VisorJob<VisorDefragmentationTaskArg, VisorDefragmentationTaskResult> {
        private static final long serialVersionUID = 0L;

        protected VisorDefragmentationJob(@Nullable VisorDefragmentationTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorDefragmentationTaskResult run(@Nullable VisorDefragmentationTaskArg arg) throws IgniteException {
            switch (arg.operation()) {
                case SCHEDULE: {
                    return this.runSchedule(arg);
                }
                case STATUS: {
                    return this.runStatus(arg);
                }
                case CANCEL: {
                    return this.runCancel(arg);
                }
            }
            throw new IllegalArgumentException("Operation: " + (Object)((Object)arg.operation()));
        }

        private VisorDefragmentationTaskResult runSchedule(VisorDefragmentationTaskArg arg) {
            String message;
            IgniteDefragmentation.ScheduleResult scheduleResult;
            IgniteDefragmentation defragmentation = this.ignite.context().defragmentation();
            try {
                scheduleResult = defragmentation.schedule(arg.cacheNames());
            }
            catch (IgniteCheckedException e) {
                return new VisorDefragmentationTaskResult(false, e.getMessage());
            }
            switch (scheduleResult) {
                case SUCCESS_SUPERSEDED_PREVIOUS: {
                    message = "Scheduling completed successfully. Previously scheduled task has been removed.";
                    break;
                }
                default: {
                    message = "Scheduling completed successfully.";
                }
            }
            return new VisorDefragmentationTaskResult(true, message);
        }

        private VisorDefragmentationTaskResult runStatus(VisorDefragmentationTaskArg arg) {
            IgniteDefragmentation defragmentation = this.ignite.context().defragmentation();
            try {
                return new VisorDefragmentationTaskResult(true, defragmentation.status().toString());
            }
            catch (IgniteCheckedException e) {
                return new VisorDefragmentationTaskResult(false, e.getMessage());
            }
        }

        private VisorDefragmentationTaskResult runCancel(VisorDefragmentationTaskArg arg) {
            IgniteDefragmentation defragmentation = this.ignite.context().defragmentation();
            try {
                String message;
                IgniteDefragmentation.CancelResult cancelResult = defragmentation.cancel();
                switch (cancelResult) {
                    case SCHEDULED_NOT_FOUND: {
                        message = "Scheduled defragmentation task is not found.";
                        break;
                    }
                    case CANCELLED: {
                        message = "Defragmentation cancelled successfully.";
                        break;
                    }
                    case COMPLETED_OR_CANCELLED: {
                        message = "Defragmentation is already completed or has been cancelled previously.";
                        break;
                    }
                    default: {
                        message = "Scheduled defragmentation task cancelled successfully.";
                    }
                }
                return new VisorDefragmentationTaskResult(true, message);
            }
            catch (IgniteCheckedException e) {
                return new VisorDefragmentationTaskResult(false, e.getMessage());
            }
        }
    }
}

