/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.gridify;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.gridify.GridifyArgument;
import org.apache.ignite.compute.gridify.GridifyInput;
import org.apache.ignite.compute.gridify.aop.GridifyArgumentAdapter;
import org.apache.ignite.internal.util.gridify.GridifyRangeArgument;
import org.apache.ignite.internal.util.gridify.GridifyUtils;

public final class GridifyArgumentBuilder {
    public GridifyRangeArgument createTaskArgument(Class<?> mtdCls, String mtdName, Class<?> mtdReturnType, Class<?>[] mtdTypes, Annotation[][] mtdParamAnns, Object[] mtdParams, Object mtdTarget) {
        GridifyRangeArgument arg = new GridifyRangeArgument();
        arg.setMethodClass(mtdCls);
        arg.setMethodName(mtdName);
        arg.setMethodReturnType(mtdReturnType);
        arg.setMethodParameterTypes(mtdTypes);
        arg.setMethodParameters(mtdParams);
        arg.setTarget(mtdTarget);
        arg.setParamIndex(this.findMethodParameterIndex(mtdName, mtdTypes, mtdParamAnns));
        return arg;
    }

    private int findMethodParameterIndex(String mtdName, Class<?>[] mtdTypes, Annotation[][] mtdParamAnns) {
        ArrayList<Integer> allowedParamIdxs = new ArrayList<Integer>(mtdTypes.length);
        for (int i = 0; i < mtdTypes.length; ++i) {
            Class<?> paramType = mtdTypes[i];
            if (!GridifyUtils.isMethodParameterTypeAllowed(paramType)) continue;
            allowedParamIdxs.add(i);
        }
        assert (!allowedParamIdxs.isEmpty()) : "Invalid method signature. Failed to get valid method parameter types [mtdName=" + mtdName + ", mtdTypes=" + Arrays.asList(mtdTypes) + ']';
        if (allowedParamIdxs.size() == 1) {
            return (Integer)allowedParamIdxs.get(0);
        }
        ArrayList<Integer> annParamIdxs = new ArrayList<Integer>(mtdTypes.length);
        for (int i = 0; i < mtdTypes.length; ++i) {
            if (!GridifyUtils.isMethodParameterTypeAnnotated(mtdParamAnns[i])) continue;
            annParamIdxs.add(i);
        }
        assert (annParamIdxs.size() == 1) : "Invalid method signature. Method parameter must be annotated with @" + GridifyInput.class.getSimpleName() + "[mtdName=" + mtdName + ", mtdTypes=" + Arrays.asList(mtdTypes) + ", allowedParamIdxs=" + allowedParamIdxs + ", annParamIdxs=" + annParamIdxs + ']';
        return (Integer)annParamIdxs.get(0);
    }

    public GridifyRangeArgument createTaskArgument(GridifyRangeArgument arg, Collection<?> input) throws IgniteCheckedException {
        GridifyRangeArgument res = new GridifyRangeArgument();
        res.setTarget(arg.getTarget());
        res.setMethodClass(arg.getMethodClass());
        res.setMethodName(arg.getMethodName());
        res.setMethodReturnType(arg.getMethodReturnType());
        res.setMethodParameterTypes(arg.getMethodParameterTypes());
        res.setParamIndex(arg.getParamIndex());
        Object[] mtdArgs = new Object[arg.getMethodParameters().length];
        System.arraycopy(arg.getMethodParameters(), 0, mtdArgs, 0, arg.getMethodParameters().length);
        res.setMethodParameters(mtdArgs);
        assert (arg.getParamIndex() != -1);
        Class<?> paramCls = arg.getMethodParameterTypes()[arg.getParamIndex()];
        assert (paramCls != null);
        Object paramValue = GridifyUtils.collectionToParameter(paramCls, input);
        if (paramValue == null) {
            throw new IgniteCheckedException("Failed to create task argument for type: " + paramCls.getName());
        }
        mtdArgs[arg.getParamIndex()] = paramValue;
        return res;
    }

    public GridifyArgument createJobArgument(GridifyRangeArgument arg, Collection<?> input) throws IgniteException {
        GridifyArgumentAdapter res = new GridifyArgumentAdapter();
        res.setTarget(arg.getTarget());
        res.setMethodClass(arg.getMethodClass());
        res.setMethodName(arg.getMethodName());
        res.setMethodParameterTypes(arg.getMethodParameterTypes());
        Object[] mtdArgs = new Object[arg.getMethodParameters().length];
        System.arraycopy(arg.getMethodParameters(), 0, mtdArgs, 0, arg.getMethodParameters().length);
        res.setMethodParameters(mtdArgs);
        assert (arg.getParamIndex() != -1);
        Class<?> paramCls = arg.getMethodParameterTypes()[arg.getParamIndex()];
        assert (paramCls != null);
        Object paramValue = GridifyUtils.collectionToParameter(paramCls, input);
        if (paramValue == null) {
            throw new IgniteException("Failed to create job argument for type: " + paramCls.getName());
        }
        mtdArgs[arg.getParamIndex()] = paramValue;
        return res;
    }
}

