/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.LocalJoinCachesContext;
import org.apache.ignite.internal.processors.cache.StateChangeRequest;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class ExchangeActions {
    private List<CacheGroupActionData> cacheGrpsToStart;
    private List<CacheGroupActionData> cacheGrpsToStop;
    private Map<String, CacheActionData> cachesToStart;
    private Map<String, CacheActionData> cachesToStop;
    private Map<String, CacheActionData> cachesToResetLostParts;
    private LocalJoinCachesContext locJoinCtx;
    private StateChangeRequest stateChangeReq;

    boolean checkStopRequestConsistency(int grpId) {
        Boolean destroy = null;
        for (CacheActionData action : this.cacheStopRequests()) {
            if (action.descriptor().groupId() != grpId) continue;
            if (destroy == null) {
                destroy = action.request().destroy();
                continue;
            }
            assert (action.request().destroy() == destroy.booleanValue()) : "Both cache stop only and cache destroy request associated with one group in batch " + this.cacheStopRequests();
        }
        return true;
    }

    public boolean clientOnlyExchange() {
        return F.isEmpty(this.cachesToStart) && F.isEmpty(this.cachesToStop) && F.isEmpty(this.cacheGrpsToStart) && F.isEmpty(this.cacheGrpsToStop) && F.isEmpty(this.cachesToResetLostParts);
    }

    public Collection<CacheActionData> cacheStartRequests() {
        return this.cachesToStart != null ? this.cachesToStart.values() : Collections.emptyList();
    }

    public Collection<CacheActionData> cacheStopRequests() {
        return this.cachesToStop != null ? this.cachesToStop.values() : Collections.emptyList();
    }

    public void completeRequestFutures(GridCacheSharedContext ctx, Throwable err) {
        this.completeRequestFutures(this.cachesToStart, ctx, err);
        this.completeRequestFutures(this.cachesToStop, ctx, err);
        this.completeRequestFutures(this.cachesToResetLostParts, ctx, err);
    }

    public boolean systemCachesStarting() {
        if (this.cachesToStart != null) {
            for (CacheActionData data : this.cachesToStart.values()) {
                if (!CU.isSystemCache(data.request().cacheName())) continue;
                return true;
            }
        }
        return false;
    }

    private void completeRequestFutures(Map<String, CacheActionData> map, GridCacheSharedContext ctx, @Nullable Throwable err) {
        if (map != null) {
            for (CacheActionData req : map.values()) {
                ctx.cache().completeCacheStartFuture(req.req, err == null, err);
            }
        }
    }

    public boolean hasStop() {
        return !F.isEmpty(this.cachesToStop);
    }

    public Set<String> cachesToResetLostPartitions() {
        Set<String> caches = null;
        if (this.cachesToResetLostParts != null) {
            caches = new HashSet<String>(this.cachesToResetLostParts.keySet());
        }
        return caches != null ? caches : Collections.emptySet();
    }

    public boolean cacheStopped(int cacheId) {
        if (this.cachesToStop != null) {
            for (CacheActionData cache : this.cachesToStop.values()) {
                if (cache.desc.cacheId() != cacheId) continue;
                return true;
            }
        }
        return false;
    }

    public boolean cacheStarted(int cacheId) {
        if (this.cachesToStart != null) {
            for (CacheActionData cache : this.cachesToStart.values()) {
                if (cache.desc.cacheId() != cacheId) continue;
                return true;
            }
        }
        return false;
    }

    public void stateChangeRequest(StateChangeRequest stateChange) {
        this.stateChangeReq = stateChange;
    }

    public boolean deactivate() {
        return this.stateChangeReq != null && this.stateChangeReq.activeChanged() && !this.stateChangeReq.state().active();
    }

    public boolean activate() {
        return this.stateChangeReq != null && this.stateChangeReq.activeChanged() && this.stateChangeReq.state().active();
    }

    public boolean changedClusterState() {
        return this.stateChangeReq != null && this.stateChangeReq.prevState() != this.stateChangeReq.state();
    }

    public boolean changedBaseline() {
        return this.stateChangeReq != null && !this.stateChangeReq.activeChanged();
    }

    @Nullable
    public StateChangeRequest stateChangeRequest() {
        return this.stateChangeReq;
    }

    private Map<String, CacheActionData> add(Map<String, CacheActionData> map, DynamicCacheChangeRequest req, DynamicCacheDescriptor desc) {
        assert (req != null);
        assert (desc != null);
        if (map == null) {
            map = new LinkedHashMap<String, CacheActionData>();
        }
        CacheActionData old = map.put(req.cacheName(), new CacheActionData(req, desc));
        assert (old == null) : old;
        return map;
    }

    void addCacheToStart(DynamicCacheChangeRequest req, DynamicCacheDescriptor desc) {
        assert (req.start()) : req;
        this.cachesToStart = this.add(this.cachesToStart, req, desc);
    }

    public void addCacheToStop(DynamicCacheChangeRequest req, DynamicCacheDescriptor desc) {
        assert (req.stop()) : req;
        this.cachesToStop = this.add(this.cachesToStop, req, desc);
    }

    void addCacheToResetLostPartitions(DynamicCacheChangeRequest req, DynamicCacheDescriptor desc) {
        assert (req.resetLostPartitions()) : req;
        this.cachesToResetLostParts = this.add(this.cachesToResetLostParts, req, desc);
    }

    void addCacheGroupToStart(CacheGroupDescriptor grpDesc) {
        assert (grpDesc != null);
        if (this.cacheGrpsToStart == null) {
            this.cacheGrpsToStart = new ArrayList<CacheGroupActionData>();
        }
        this.cacheGrpsToStart.add(new CacheGroupActionData(grpDesc));
    }

    public List<CacheGroupActionData> cacheGroupsToStart() {
        return this.cacheGrpsToStart != null ? this.cacheGrpsToStart : Collections.emptyList();
    }

    public boolean cacheGroupStarting(int grpId) {
        if (this.cacheGrpsToStart != null) {
            for (CacheGroupActionData grp : this.cacheGrpsToStart) {
                if (grp.desc.groupId() != grpId) continue;
                return true;
            }
        }
        return false;
    }

    public void addCacheGroupToStop(CacheGroupDescriptor grpDesc, boolean destroy) {
        assert (grpDesc != null);
        if (this.cacheGrpsToStop == null) {
            this.cacheGrpsToStop = new ArrayList<CacheGroupActionData>();
        }
        this.cacheGrpsToStop.add(new CacheGroupActionData(grpDesc, destroy));
    }

    public List<CacheGroupActionData> cacheGroupsToStop() {
        return this.cacheGrpsToStop != null ? this.cacheGrpsToStop : Collections.emptyList();
    }

    public boolean cacheGroupStopping(int grpId) {
        if (this.cacheGrpsToStop != null) {
            for (CacheGroupActionData grp : this.cacheGrpsToStop) {
                if (grp.desc.groupId() != grpId) continue;
                return true;
            }
        }
        return false;
    }

    public boolean empty() {
        return F.isEmpty(this.cachesToStart) && F.isEmpty(this.cachesToStop) && F.isEmpty(this.cacheGrpsToStart) && F.isEmpty(this.cacheGrpsToStop) && F.isEmpty(this.cachesToResetLostParts) && this.stateChangeReq == null && this.locJoinCtx == null;
    }

    public void localJoinContext(LocalJoinCachesContext locJoinCtx) {
        this.locJoinCtx = locJoinCtx;
    }

    public LocalJoinCachesContext localJoinContext() {
        return this.locJoinCtx;
    }

    public String toString() {
        Collection<String> startGrps = F.viewReadOnly(this.cacheGrpsToStart, new C1<CacheGroupActionData, String>(){

            @Override
            public String apply(CacheGroupActionData data) {
                return data.desc.cacheOrGroupName();
            }
        }, new IgnitePredicate[0]);
        Collection<String> stopGrps = F.viewReadOnly(this.cacheGrpsToStop, new C1<CacheGroupActionData, String>(){

            @Override
            public String apply(CacheGroupActionData data) {
                return data.desc.cacheOrGroupName() + ", destroy=" + data.destroy;
            }
        }, new IgnitePredicate[0]);
        return "ExchangeActions [startCaches=" + (this.cachesToStart != null ? this.cachesToStart.keySet() : null) + ", stopCaches=" + (this.cachesToStop != null ? this.cachesToStop.keySet() : null) + ", startGrps=" + startGrps + ", stopGrps=" + stopGrps + ", resetParts=" + (this.cachesToResetLostParts != null ? this.cachesToResetLostParts.keySet() : null) + ", stateChangeRequest=" + this.stateChangeReq + ']';
    }

    public static class CacheGroupActionData {
        private final CacheGroupDescriptor desc;
        private final boolean destroy;

        CacheGroupActionData(CacheGroupDescriptor desc, boolean destroy) {
            assert (desc != null);
            this.desc = desc;
            this.destroy = destroy;
        }

        CacheGroupActionData(CacheGroupDescriptor desc) {
            this(desc, false);
        }

        public CacheGroupDescriptor descriptor() {
            return this.desc;
        }

        public boolean destroy() {
            return this.destroy;
        }
    }

    public static class CacheActionData {
        private final DynamicCacheChangeRequest req;
        private final DynamicCacheDescriptor desc;

        CacheActionData(DynamicCacheChangeRequest req, DynamicCacheDescriptor desc) {
            assert (req != null);
            assert (desc != null);
            this.req = req;
            this.desc = desc;
        }

        public DynamicCacheChangeRequest request() {
            return this.req;
        }

        public DynamicCacheDescriptor descriptor() {
            return this.desc;
        }
    }
}

