/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.compute.ComputeTaskName;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.events.DeploymentEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentClassLoader;
import org.apache.ignite.internal.managers.deployment.GridDeploymentCommunication;
import org.apache.ignite.internal.managers.deployment.GridDeploymentMetadata;
import org.apache.ignite.internal.managers.deployment.GridDeploymentStoreAdapter;
import org.apache.ignite.internal.util.GridAnnotationsCache;
import org.apache.ignite.internal.util.GridClassLoaderCache;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.AbstractMarshaller;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.deployment.DeploymentListener;
import org.apache.ignite.spi.deployment.DeploymentResource;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.jetbrains.annotations.Nullable;

class GridDeploymentLocalStore
extends GridDeploymentStoreAdapter {
    private final ConcurrentMap<String, Deque<GridDeployment>> cache = new ConcurrentHashMap<String, Deque<GridDeployment>>();
    private final Object mux = new Object();

    GridDeploymentLocalStore(DeploymentSpi spi, GridKernalContext ctx, GridDeploymentCommunication comm) {
        super(spi, ctx, comm);
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.spi.setListener(new LocalDeploymentListener());
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        HashMap<String, Deque<GridDeployment>> cp;
        this.spi.setListener(null);
        Iterator iterator = this.mux;
        synchronized (iterator) {
            cp = new HashMap<String, Deque<GridDeployment>>(this.cache);
            for (Map.Entry entry : cp.entrySet()) {
                entry.setValue(new ArrayList((Collection)entry.getValue()));
            }
        }
        for (Collection deps : cp.values()) {
            for (GridDeployment cls : deps) {
                this.undeploy(cls.classLoader());
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GridDeployment> getDeployments() {
        ArrayList<GridDeployment> deps = new ArrayList<GridDeployment>();
        Object object = this.mux;
        synchronized (object) {
            for (Deque depList : this.cache.values()) {
                for (GridDeployment d : depList) {
                    if (deps.contains(d)) continue;
                    deps.add(d);
                }
            }
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GridDeployment getDeployment(IgniteUuid ldrId) {
        Iterator<GridDeployment> iterator = this.mux;
        synchronized (iterator) {
            for (Deque deps : this.cache.values()) {
                for (GridDeployment dep : deps) {
                    if (!dep.classLoaderId().equals(ldrId)) continue;
                    return dep;
                }
            }
        }
        for (GridDeployment dep : this.ctx.task().getUsedDeployments()) {
            if (!dep.classLoaderId().equals(ldrId)) continue;
            return dep;
        }
        return null;
    }

    @Override
    @Nullable
    public GridDeployment getDeployment(GridDeploymentMetadata meta) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deployment meta for local deployment: " + meta);
        }
        String alias = meta.alias();
        assert (alias != null) : "Meta is invalid: " + meta;
        GridDeployment dep = this.deployment(alias);
        if (dep != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Acquired deployment class from local cache: " + dep);
            }
            return dep;
        }
        DeploymentResource rsrc = this.spi.findResource(alias);
        if (rsrc != null) {
            dep = this.deploy(this.ctx.config().getDeploymentMode(), rsrc.getClassLoader(), rsrc.getResourceClass(), alias, meta.record());
            assert (dep != null);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Acquired deployment class from SPI: " + dep);
            }
        } else {
            ClassLoader ldr = meta.classLoader();
            if (ldr == null && (ldr = Thread.currentThread().getContextClassLoader()) == null) {
                ldr = U.resolveClassLoader(this.ctx.config());
            }
            if (ldr instanceof GridDeploymentClassLoader) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Skipping local auto-deploy (nested execution) [ldr=" + ldr + ", meta=" + meta + ']');
                }
                return null;
            }
            try {
                block17: {
                    Class<?> cls;
                    do {
                        String clsName;
                        cls = U.forName((clsName = meta.className()) != null ? clsName : alias, ldr);
                        this.spi.register(ldr, cls);
                        rsrc = this.spi.findResource(cls.getName());
                        if (rsrc == null || !rsrc.getResourceClass().equals(cls)) break block17;
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Retrieved auto-loaded resource from spi: " + rsrc);
                    } while ((dep = this.deploy(this.ctx.config().getDeploymentMode(), ldr, cls, meta.alias(), meta.record())) == null);
                    return dep;
                }
                U.warn(this.log, "Failed to find resource from deployment SPI even after registering: " + meta);
                return null;
            }
            catch (ClassNotFoundException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to load class for local auto-deployment [ldr=" + ldr + ", meta=" + meta + ']');
                }
                return null;
            }
            catch (IgniteSpiException e) {
                U.error(this.log, "Failed to deploy local class with meta: " + meta, e);
                return null;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Acquired deployment class: " + dep);
        }
        return dep;
    }

    @Override
    public GridDeployment searchDeploymentCache(GridDeploymentMetadata meta) {
        return this.deployment(meta.alias());
    }

    @Nullable
    private GridDeployment deployment(String alias) {
        GridDeployment dep;
        Deque deps = (Deque)this.cache.get(alias);
        if (deps != null && (dep = (GridDeployment)deps.peekFirst()) != null && !dep.undeployed()) {
            return dep;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GridDeployment deploy(DeploymentMode depMode, ClassLoader ldr, Class<?> cls, String alias, boolean recordEvt) {
        GridDeployment dep = null;
        Object object = this.mux;
        synchronized (object) {
            boolean fireEvt = false;
            try {
                Deque cachedDeps = null;
                for (Deque deps : this.cache.values()) {
                    for (GridDeployment d : deps) {
                        if (d.classLoader() != ldr) continue;
                        fireEvt = d.addDeployedClass(cls, alias);
                        cachedDeps = deps;
                        dep = d;
                        break;
                    }
                    if (cachedDeps == null) continue;
                }
                if (cachedDeps != null) {
                    assert (dep != null);
                    this.cache.put(alias, cachedDeps);
                    if (!cls.getName().equals(alias)) {
                        this.cache.put(cls.getName(), cachedDeps);
                    }
                    Iterator iterator = dep;
                    return iterator;
                }
                IgniteUuid ldrId = IgniteUuid.fromUuid(this.ctx.localNodeId());
                String userVer = this.userVersion(ldr);
                dep = new GridDeployment(depMode, ldr, ldrId, userVer, cls.getName(), true);
                fireEvt = dep.addDeployedClass(cls, alias);
                assert (fireEvt) : "Class was not added to newly created deployment [cls=" + cls + ", depMode=" + (Object)((Object)depMode) + ", dep=" + dep + ']';
                Deque deps = (Deque)((Object)F.addIfAbsent(this.cache, alias, ConcurrentLinkedDeque::new));
                if (!deps.isEmpty()) {
                    for (GridDeployment d : deps) {
                        if (d.undeployed()) continue;
                        U.error(this.log, "Found more than one active deployment for the same resource [cls=" + cls + ", depMode=" + (Object)((Object)depMode) + ", dep=" + d + ']');
                        GridDeployment gridDeployment = null;
                        return gridDeployment;
                    }
                }
                deps.addFirst(dep);
                if (!cls.getName().equals(alias)) {
                    this.cache.put(cls.getName(), deps);
                }
                if (!this.log.isDebugEnabled()) return dep;
                this.log.debug("Created new deployment: " + dep);
            }
            finally {
                if (fireEvt) {
                    this.recordDeploy(cls, alias, recordEvt);
                }
            }
            return dep;
        }
    }

    @Override
    @Nullable
    public GridDeployment explicitDeploy(Class<?> cls, ClassLoader clsLdr) throws IgniteCheckedException {
        try {
            if (clsLdr.getClass().equals(GridDeploymentClassLoader.class)) {
                clsLdr = clsLdr.getParent();
            }
            GridDeployment dep = null;
            while (dep == null) {
                DeploymentResource rsrc;
                this.spi.register(clsLdr, cls);
                dep = this.deployment(cls.getName());
                if (dep != null || (rsrc = this.spi.findResource(cls.getName())) == null || rsrc.getClassLoader() != clsLdr) continue;
                dep = this.deploy(this.ctx.config().getDeploymentMode(), rsrc.getClassLoader(), rsrc.getResourceClass(), rsrc.getName(), true);
            }
            return dep;
        }
        catch (IgniteSpiException e) {
            this.recordDeployFailed(cls, clsLdr, true);
            if (e.getCause() instanceof IgniteCheckedException) {
                throw (IgniteCheckedException)e.getCause();
            }
            throw new IgniteDeploymentCheckedException("Failed to deploy class: " + cls.getName(), e);
        }
    }

    @Override
    public void explicitUndeploy(UUID nodeId, String rsrcName) {
        assert (rsrcName != null);
        this.spi.unregister(rsrcName);
    }

    @Override
    public void addParticipants(Map<UUID, IgniteUuid> allParticipants, Map<UUID, IgniteUuid> addedParticipants) {
        assert (false);
    }

    private void recordDeploy(Class<?> cls, String alias, boolean recordEvt) {
        assert (cls != null);
        boolean isTask = this.isTask(cls);
        String msg = (isTask ? "Task" : "Class") + " locally deployed: " + cls;
        if (recordEvt && this.ctx.event().isRecordable(isTask ? 33 : 30)) {
            DeploymentEvent evt = new DeploymentEvent();
            evt.message(msg);
            evt.node(this.ctx.discovery().localNode());
            evt.type(isTask ? 33 : 30);
            evt.alias(alias);
            this.ctx.event().record(evt);
        }
        if (U.isGrid(cls) || U.isJdk(cls)) {
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(msg);
        }
    }

    private void recordDeployFailed(Class<?> cls, ClassLoader clsLdr, boolean recordEvt) {
        assert (cls != null);
        assert (clsLdr != null);
        boolean isTask = this.isTask(cls);
        String msg = "Failed to deploy " + (isTask ? "task" : "class") + " [cls=" + cls + ", clsLdr=" + clsLdr + ']';
        if (recordEvt && this.ctx.event().isRecordable(isTask ? 32 : 35)) {
            String taskName = isTask ? U.getTaskName(cls) : null;
            DeploymentEvent evt = new DeploymentEvent();
            evt.message(msg);
            evt.node(this.ctx.discovery().localNode());
            evt.type(isTask ? 32 : 35);
            evt.alias(taskName);
            this.ctx.event().record(evt);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(msg);
        }
    }

    private void recordUndeploy(GridDeployment dep) {
        assert (dep.undeployed());
        if (this.ctx.event().isRecordable(34) || this.ctx.event().isRecordable(31)) {
            for (Class<?> cls : dep.deployedClasses()) {
                boolean isTask = this.isTask(cls);
                String msg = isTask ? "Task locally undeployed: " + cls : "Class locally undeployed: " + cls;
                if (this.ctx.event().isRecordable(isTask ? 34 : 31)) {
                    DeploymentEvent evt = new DeploymentEvent();
                    evt.message(msg);
                    evt.node(this.ctx.discovery().localNode());
                    evt.type(isTask ? 34 : 31);
                    evt.alias(this.getAlias(dep, cls));
                    this.ctx.event().record(evt);
                }
                if (!this.log.isInfoEnabled()) continue;
                this.log.info(msg);
            }
        }
    }

    private String getAlias(GridDeployment dep, Class<?> cls) {
        ComputeTaskName ann;
        String alias = cls.getName();
        if (this.isTask(cls) && (ann = dep.annotation(cls, ComputeTaskName.class)) != null) {
            alias = ann.value();
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(ClassLoader ldr) {
        HashSet<GridDeployment> doomed = new HashSet<GridDeployment>();
        Iterator iterator = this.mux;
        synchronized (iterator) {
            Iterator i1 = this.cache.values().iterator();
            while (i1.hasNext()) {
                Deque deps = (Deque)i1.next();
                Iterator i2 = deps.iterator();
                while (i2.hasNext()) {
                    GridDeployment dep = (GridDeployment)i2.next();
                    if (dep.classLoader() != ldr) continue;
                    dep.undeploy();
                    i2.remove();
                    doomed.add(dep);
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("Removed undeployed class: " + dep);
                }
                if (!deps.isEmpty()) continue;
                i1.remove();
            }
        }
        for (GridDeployment dep : doomed) {
            if (dep.obsolete()) {
                this.ctx.resource().onUndeployed(dep);
                if (this.ctx.config().getMarshaller() instanceof AbstractMarshaller) {
                    ((AbstractMarshaller)this.ctx.config().getMarshaller()).onUndeploy(ldr);
                }
                this.clearSerializationCaches();
                GridAnnotationsCache.onUndeployed(ldr);
                GridClassLoaderCache.onUndeployed(ldr);
            }
            this.recordUndeploy(dep);
        }
    }

    @Override
    public String toString() {
        return S.toString(GridDeploymentLocalStore.class, this);
    }

    private class LocalDeploymentListener
    implements DeploymentListener {
        private LocalDeploymentListener() {
        }

        @Override
        public void onUnregistered(ClassLoader ldr) {
            if (GridDeploymentLocalStore.this.log.isDebugEnabled()) {
                GridDeploymentLocalStore.this.log.debug("Received callback from SPI to unregister class loader: " + ldr);
            }
            GridDeploymentLocalStore.this.undeploy(ldr);
        }
    }
}

