/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientFutureTimeoutException;
import org.apache.ignite.internal.jdbc.JdbcDatabaseMetadata;
import org.apache.ignite.internal.jdbc.JdbcPreparedStatement;
import org.apache.ignite.internal.jdbc.JdbcStatement;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;

@Deprecated
public class JdbcConnection
implements Connection {
    private static final String CONNECTION_VALID_TASK_NAME = "org.apache.ignite.internal.jdbc.JdbcConnectionValidationTask";
    private static final String CACHE_VALID_TASK_NAME = "org.apache.ignite.internal.processors.cache.query.jdbc.GridCacheQueryJdbcValidationTask";
    private final GridClient client;
    private String cacheName;
    private boolean closed;
    private String url;
    private UUID nodeId;
    private int timeout;
    private boolean usingSecurity;

    public JdbcConnection(String url, Properties props) throws SQLException {
        assert (url != null);
        assert (props != null);
        this.url = url;
        this.cacheName = props.getProperty("ignite.jdbc.cache");
        String nodeIdProp = props.getProperty("ignite.jdbc.nodeId");
        if (nodeIdProp != null) {
            this.nodeId = UUID.fromString(nodeIdProp);
        }
        try {
            GridClientConfiguration cfg = new GridClientConfiguration(props);
            cfg.setServers(Collections.singleton(props.getProperty("ignite.jdbc.host") + ":" + props.getProperty("ignite.jdbc.port")));
            String user = props.getProperty("user");
            String passwd = props.getProperty("password");
            if (!F.isEmpty(user)) {
                this.usingSecurity = true;
                SecurityCredentials creds = new SecurityCredentials(user, passwd);
                cfg.setSecurityCredentialsProvider(new SecurityCredentialsBasicProvider(creds));
            } else {
                this.usingSecurity = false;
            }
            cfg.setEnableMetricsCache(false);
            cfg.setEnableAttributesCache(false);
            cfg.setAutoFetchMetrics(false);
            cfg.setAutoFetchAttributes(false);
            this.client = GridClientFactory.start(cfg);
        }
        catch (GridClientException e) {
            throw new SQLException("Failed to start Ignite client.", e);
        }
        if (!this.isValid(2)) {
            throw new SQLException("Client is invalid. Probably cache name is wrong.");
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.ensureNotClosed();
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureNotClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureNotClosed();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Transactions are not supported.");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureNotClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        GridClientFactory.stop(this.client.id(), false);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        return new JdbcDatabaseMetadata(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureNotClosed();
        if (!readOnly) {
            throw new SQLFeatureNotSupportedException("Updates are not supported.");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureNotClosed();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Catalogs are not supported.");
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency) throws SQLException {
        return this.createStatement(resSetType, resSetConcurrency, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        return this.prepareStatement(sql, resSetType, resSetConcurrency, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureNotClosed();
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException("Invalid holdability (transactions are not supported).");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported.)");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
        if (resSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("Invalid holdability (transactions are not supported).");
        }
        JdbcStatement stmt = new JdbcStatement(this);
        if (this.timeout > 0) {
            stmt.timeout(this.timeout);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported.)");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
        if (resSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("Invalid holdability (transactions are not supported).");
        }
        JdbcPreparedStatement stmt = new JdbcPreparedStatement(this, sql);
        if (this.timeout > 0) {
            stmt.timeout(this.timeout);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.ensureNotClosed();
        if (timeout < 0) {
            throw new SQLException("Invalid timeout: " + timeout);
        }
        try {
            return (Boolean)this.client.compute().executeAsync(this.usingSecurity ? CONNECTION_VALID_TASK_NAME : CACHE_VALID_TASK_NAME, this.cacheName).get(timeout, TimeUnit.SECONDS);
        }
        catch (GridClientDisconnectedException | GridClientFutureTimeoutException e) {
            throw new SQLException("Failed to establish connection.", e);
        }
        catch (GridClientException ignored) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String val) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Client info is not supported.");
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Client info is not supported.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureNotClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attrs) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Connection is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface == Connection.class;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.cacheName = schema;
    }

    @Override
    public String getSchema() throws SQLException {
        return this.cacheName;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int ms) throws SQLException {
        if (ms < 0) {
            throw new IllegalArgumentException("Timeout is below zero: " + ms);
        }
        this.timeout = ms;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.timeout;
    }

    GridClient client() {
        return this.client;
    }

    String cacheName() {
        return this.cacheName;
    }

    String url() {
        return this.url;
    }

    UUID nodeId() {
        return this.nodeId;
    }

    private void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    JdbcStatement createStatement0() throws SQLException {
        return (JdbcStatement)this.createStatement();
    }
}

