/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.api;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.internal.util.TransformingIterator;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.NoRowSetExpectedException;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class AsyncResultSetImpl<T>
implements AsyncResultSet<T> {
    private final AsyncSqlCursor<InternalSqlRow> cursor;
    private volatile AsyncCursor.BatchedResult<InternalSqlRow> curPage;
    private final int pageSize;

    public AsyncResultSetImpl(AsyncSqlCursor<InternalSqlRow> cursor, AsyncCursor.BatchedResult<InternalSqlRow> page, int pageSize) {
        this.cursor = cursor;
        this.curPage = page;
        this.pageSize = pageSize;
    }

    @Nullable
    public ResultSetMetadata metadata() {
        return this.hasRowSet() ? this.cursor.metadata() : null;
    }

    public boolean hasRowSet() {
        SqlQueryType queryType = this.cursor.queryType();
        return queryType.hasRowSet();
    }

    public long affectedRows() {
        SqlQueryType queryType = this.cursor.queryType();
        if (!queryType.returnsAffectedRows()) {
            return -1L;
        }
        assert (((InternalSqlRow)this.curPage.items().get(0)).get(0) instanceof Long) : "Invalid DML result: " + String.valueOf(this.curPage);
        return (Long)((InternalSqlRow)this.curPage.items().get(0)).get(0);
    }

    public boolean wasApplied() {
        SqlQueryType queryType = this.cursor.queryType();
        if (!queryType.supportsWasApplied()) {
            return false;
        }
        assert (((InternalSqlRow)this.curPage.items().get(0)).get(0) instanceof Boolean) : "Invalid DDL/KILL result: " + String.valueOf(this.curPage);
        return (Boolean)((InternalSqlRow)this.curPage.items().get(0)).get(0);
    }

    public Iterable<T> currentPage() {
        this.requireResultSet();
        Iterator it0 = this.curPage.items().iterator();
        ResultSetMetadata meta0 = this.cursor.metadata();
        return () -> new TransformingIterator(it0, item -> new SqlRowImpl((InternalSqlRow)item, meta0));
    }

    public int currentPageSize() {
        this.requireResultSet();
        return this.curPage.items().size();
    }

    public CompletableFuture<? extends AsyncResultSet<T>> fetchNextPage() {
        this.requireResultSet();
        return this.cursor.requestNextAsync(this.pageSize).thenApply(page -> {
            this.curPage = page;
            if (!this.curPage.hasMore()) {
                this.closeAsync();
            }
            return this;
        });
    }

    public boolean hasMorePages() {
        return this.curPage.hasMore();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.cursor.closeAsync();
    }

    private void requireResultSet() {
        if (!this.hasRowSet()) {
            throw new NoRowSetExpectedException();
        }
    }

    private static class SqlRowImpl
    implements SqlRow {
        private final InternalSqlRow row;
        private final ResultSetMetadata meta;

        SqlRowImpl(InternalSqlRow row, ResultSetMetadata meta) {
            this.row = row;
            this.meta = meta;
        }

        public int columnCount() {
            return this.meta.columns().size();
        }

        public String columnName(int columnIndex) {
            return ((ColumnMetadata)this.meta.columns().get(columnIndex)).name();
        }

        public int columnIndex(String columnName) {
            return this.meta.indexOf(columnName);
        }

        private int columnIndexChecked(String columnName) {
            int idx = this.columnIndex(columnName);
            if (idx == -1) {
                throw new IllegalArgumentException("Column doesn't exist [name=" + columnName + "]");
            }
            return idx;
        }

        public <T> T valueOrDefault(String columnName, T defaultValue) {
            Object ret = this.row.get(this.columnIndexChecked(columnName));
            return (T)(ret != null ? ret : defaultValue);
        }

        public Tuple set(String columnName, Object value) {
            throw new UnsupportedOperationException("Operation not supported.");
        }

        public <T> T value(String columnName) throws IllegalArgumentException {
            return (T)this.row.get(this.columnIndexChecked(columnName));
        }

        public <T> T value(int columnIndex) {
            return (T)this.row.get(columnIndex);
        }

        public boolean booleanValue(String columnName) {
            return (Boolean)this.row.get(this.columnIndexChecked(columnName));
        }

        public boolean booleanValue(int columnIndex) {
            return (Boolean)this.row.get(columnIndex);
        }

        public byte byteValue(String columnName) {
            return (Byte)this.row.get(this.columnIndexChecked(columnName));
        }

        public byte byteValue(int columnIndex) {
            return (Byte)this.row.get(columnIndex);
        }

        public short shortValue(String columnName) {
            return (Short)this.row.get(this.columnIndexChecked(columnName));
        }

        public short shortValue(int columnIndex) {
            return (Short)this.row.get(columnIndex);
        }

        public int intValue(String columnName) {
            return (Integer)this.row.get(this.columnIndexChecked(columnName));
        }

        public int intValue(int columnIndex) {
            return (Integer)this.row.get(columnIndex);
        }

        public long longValue(String columnName) {
            return (Long)this.row.get(this.columnIndexChecked(columnName));
        }

        public long longValue(int columnIndex) {
            return (Long)this.row.get(columnIndex);
        }

        public float floatValue(String columnName) {
            return ((Float)this.row.get(this.columnIndexChecked(columnName))).floatValue();
        }

        public float floatValue(int columnIndex) {
            return ((Float)this.row.get(columnIndex)).floatValue();
        }

        public double doubleValue(String columnName) {
            return (Double)this.row.get(this.columnIndexChecked(columnName));
        }

        public double doubleValue(int columnIndex) {
            return (Double)this.row.get(columnIndex);
        }

        public BigDecimal decimalValue(String columnName) {
            return (BigDecimal)this.row.get(this.columnIndexChecked(columnName));
        }

        public BigDecimal decimalValue(int columnIndex) {
            return (BigDecimal)this.row.get(columnIndex);
        }

        public String stringValue(String columnName) {
            return (String)this.row.get(this.columnIndexChecked(columnName));
        }

        public String stringValue(int columnIndex) {
            return (String)this.row.get(columnIndex);
        }

        public UUID uuidValue(String columnName) {
            return (UUID)this.row.get(this.columnIndexChecked(columnName));
        }

        public UUID uuidValue(int columnIndex) {
            return (UUID)this.row.get(columnIndex);
        }

        public LocalDate dateValue(String columnName) {
            return (LocalDate)this.row.get(this.columnIndexChecked(columnName));
        }

        public LocalDate dateValue(int columnIndex) {
            return (LocalDate)this.row.get(columnIndex);
        }

        public LocalTime timeValue(String columnName) {
            return (LocalTime)this.row.get(this.columnIndexChecked(columnName));
        }

        public LocalTime timeValue(int columnIndex) {
            return (LocalTime)this.row.get(columnIndex);
        }

        public LocalDateTime datetimeValue(String columnName) {
            return (LocalDateTime)this.row.get(this.columnIndexChecked(columnName));
        }

        public LocalDateTime datetimeValue(int columnIndex) {
            return (LocalDateTime)this.row.get(columnIndex);
        }

        public Instant timestampValue(String columnName) {
            return (Instant)this.row.get(this.columnIndexChecked(columnName));
        }

        public Instant timestampValue(int columnIndex) {
            return (Instant)this.row.get(columnIndex);
        }

        public ResultSetMetadata metadata() {
            return this.meta;
        }

        public String toString() {
            return "Row " + String.valueOf(this.row);
        }
    }
}

