/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.configuration;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.configuration.ClusterConfigUpdateCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.rest.client.api.ClusterConfigurationApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.Configuration;

@Singleton
public class ClusterConfigUpdateCall
implements Call<ClusterConfigUpdateCallInput, String> {
    @Override
    public DefaultCallOutput<String> execute(ClusterConfigUpdateCallInput input) {
        ClusterConfigurationApi client = this.createApiClient(input);
        try {
            return this.updateClusterConfig(client, input);
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getClusterUrl()));
        }
    }

    private DefaultCallOutput<String> updateClusterConfig(ClusterConfigurationApi api, ClusterConfigUpdateCallInput input) throws ApiException {
        api.updateClusterConfiguration(input.getConfig());
        return DefaultCallOutput.success("Cluster configuration was updated successfully");
    }

    private ClusterConfigurationApi createApiClient(ClusterConfigUpdateCallInput input) {
        return new ClusterConfigurationApi(Configuration.getDefaultApiClient().setBasePath(input.getClusterUrl()));
    }
}

