/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.util.concurrent.Future;
import org.apache.hc.client5.http.fluent.Content;
import org.apache.hc.client5.http.fluent.ContentResponseHandler;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class Async {
    private Executor executor;
    private java.util.concurrent.Executor concurrentExec;

    public static Async newInstance() {
        return new Async();
    }

    Async() {
    }

    public Async use(Executor executor) {
        this.executor = executor;
        return this;
    }

    public Async use(java.util.concurrent.Executor concurrentExec) {
        this.concurrentExec = concurrentExec;
        return this;
    }

    public <T> Future<T> execute(Request request, HttpClientResponseHandler<T> handler, FutureCallback<T> callback) {
        BasicFuture future = new BasicFuture(callback);
        ExecRunnable<T> runnable = new ExecRunnable<T>(future, request, this.executor != null ? this.executor : Executor.newInstance(), handler);
        if (this.concurrentExec != null) {
            this.concurrentExec.execute(runnable);
        } else {
            Thread t = new Thread(runnable);
            t.setDaemon(true);
            t.start();
        }
        return future;
    }

    public <T> Future<T> execute(Request request, HttpClientResponseHandler<T> handler) {
        return this.execute(request, handler, null);
    }

    public Future<Content> execute(Request request, FutureCallback<Content> callback) {
        return this.execute(request, (HttpClientResponseHandler)new ContentResponseHandler(), (FutureCallback)callback);
    }

    public Future<Content> execute(Request request) {
        return this.execute(request, (HttpClientResponseHandler)new ContentResponseHandler(), null);
    }

    static class ExecRunnable<T>
    implements Runnable {
        private final BasicFuture<T> future;
        private final Request request;
        private final Executor executor;
        private final HttpClientResponseHandler<T> handler;

        ExecRunnable(BasicFuture<T> future, Request request, Executor executor, HttpClientResponseHandler<T> handler) {
            this.future = future;
            this.request = request;
            this.executor = executor;
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                Response response = this.executor.execute(this.request);
                T result = response.handleResponse(this.handler);
                this.future.completed(result);
            }
            catch (Exception ex) {
                this.future.failed(ex);
            }
        }
    }
}

