/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.authentication;

import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import org.apache.geronimo.javamail.authentication.ClientAuthenticator;

public class PlainAuthenticator
implements ClientAuthenticator {
    protected String authzid;
    protected String username;
    protected String password;
    protected boolean complete = false;

    public PlainAuthenticator(String authzid, String username, String password) {
        this.authzid = authzid;
        this.username = username;
        this.password = password;
    }

    public PlainAuthenticator(String username, String password) {
        this(null, username, password);
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws MessagingException {
        try {
            String result = "\u0000" + this.username + "\u0000" + this.password;
            if (this.authzid != null && this.authzid.length() > 0) {
                result = this.authzid + result;
            }
            this.complete = true;
            return result.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Invalid encoding");
        }
    }
}

