/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

public class StopWatch {
    private long startTime;
    private long stopTime;

    public StopWatch() {
        this(false);
    }

    public StopWatch(boolean start) {
        if (start) {
            this.start();
        }
    }

    public long elapsedTimeMillis() {
        if (this.stopTime == 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.stopTime = 0L;
    }

    public void stop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Attempted to stop non-running StopWatch");
        }
        this.stopTime = System.currentTimeMillis();
    }

    public boolean isRunning() {
        return this.startTime > 0L && this.stopTime == 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[StopWatch: ");
        sb.append("startTime=").append(this.startTime);
        sb.append(", stopTime=").append(this.stopTime);
        sb.append(", isRunning=").append(this.isRunning());
        sb.append("]");
        return sb.toString();
    }
}

