/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.yarn;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.apache.fluo.yarn.FluoYarnEnv;
import org.apache.twill.api.ResourceReport;
import org.apache.twill.api.ResourceSpecification;
import org.apache.twill.api.TwillApplication;
import org.apache.twill.api.TwillController;
import org.apache.twill.api.TwillPreparer;
import org.apache.twill.api.TwillRunnable;
import org.apache.twill.api.TwillSpecification;
import org.apache.twill.ext.BundledJarRunnable;
import org.apache.twill.ext.BundledJarRunner;
import org.apache.twill.yarn.YarnTwillRunnerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluoYarnLauncher {
    private static final Logger log = LoggerFactory.getLogger(FluoYarnLauncher.class);
    private static final String ORACLE_ID = "Oracle";
    private static final String WORKER_ID = "Worker";
    private static final String CONN_PROPS = "fluo-conn.properties";
    private static final String LOG4J_PROPS = "log4j.properties";

    private static int getNumRunning(TwillController controller) {
        ResourceReport report = controller.getResourceReport();
        if (report == null) {
            return 0;
        }
        int total = 0;
        Collection resources = report.getRunnableResources(ORACLE_ID);
        if (resources != null) {
            total += resources.size();
        }
        if ((resources = report.getRunnableResources(WORKER_ID)) != null) {
            total += resources.size();
        }
        return total;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.err.println("Invalid arguments");
            System.exit(-1);
        }
        String connProps = args[0];
        String yarnProps = args[1];
        String logProps = args[2];
        String appName = args[3];
        String jarPath = args[4];
        FluoYarnEnv env = new FluoYarnEnv(yarnProps, connProps, logProps, appName, jarPath);
        BundledJarRunner.Arguments oracleArgs = new BundledJarRunner.Arguments.Builder().setJarFileName(env.getBundledJarName()).setLibFolder("lib").setMainClassName("org.apache.fluo.command.FluoOracle").setMainArgs(new String[]{"-a", appName}).createArguments();
        BundledJarRunner.Arguments workerArgs = new BundledJarRunner.Arguments.Builder().setJarFileName(env.getBundledJarName()).setLibFolder("lib").setMainClassName("org.apache.fluo.command.FluoWorker").setMainArgs(new String[]{"-a", appName}).createArguments();
        YarnTwillRunnerService twillRunner = new YarnTwillRunnerService(env.getYarnConfiguration(), env.getZookeepers());
        twillRunner.start();
        TwillPreparer preparer = twillRunner.prepare((TwillApplication)new FluoYarnApp(env)).addJVMOptions("-Dlog4j.configuration=file:$PWD/log4j.properties").addJVMOptions("-Dfluo.conn.props=fluo-conn.properties").withArguments(ORACLE_ID, oracleArgs.toArray()).withArguments(WORKER_ID, workerArgs.toArray());
        if (env.getYarnQueue() != null) {
            preparer.setSchedulerQueue(env.getYarnQueue());
        }
        if (env.getWorkerReservedMemory() != null) {
            preparer.withConfiguration(WORKER_ID, Collections.singletonMap("twill.java.reserved.memory.mb", env.getWorkerReservedMemory()));
        }
        if (env.getOracleReservedMemory() != null) {
            preparer.withConfiguration(ORACLE_ID, Collections.singletonMap("twill.java.reserved.memory.mb", env.getOracleReservedMemory()));
        }
        TwillController controller = preparer.start();
        ResourceReport report = controller.getResourceReport();
        log.info("Waiting for Fluo application '{}' to start in YARN...", (Object)appName);
        while (report == null) {
            Thread.sleep(500L);
            report = controller.getResourceReport();
        }
        String appID = report.getApplicationId();
        log.info("Fluo application '{}' has started in YARN with ID '{}'", (Object)appName, (Object)appID);
        log.info("Waiting for all containers of Fluo application '{}' to start in YARN...", (Object)appName);
        int numRunning = FluoYarnLauncher.getNumRunning(controller);
        while (numRunning != env.getTotalInstances()) {
            log.info("{} of {} containers have started in YARN", (Object)numRunning, (Object)env.getTotalInstances());
            Thread.sleep(2000L);
            numRunning = FluoYarnLauncher.getNumRunning(controller);
        }
        log.info("{} of {} containers have started in YARN", (Object)numRunning, (Object)env.getTotalInstances());
        log.info("Fluo application '{}' has successfully started in YARN with ID '{}'", (Object)appName, (Object)appID);
    }

    private static class FluoYarnApp
    implements TwillApplication {
        private FluoYarnEnv env;

        FluoYarnApp(FluoYarnEnv env) {
            this.env = env;
        }

        public TwillSpecification configure() {
            ResourceSpecification oracleResources = ResourceSpecification.Builder.with().setVirtualCores(this.env.getOracleCores()).setMemory(this.env.getOracleMaxMemory(), ResourceSpecification.SizeUnit.MEGA).setInstances(this.env.getOracleInstances()).build();
            ResourceSpecification workerResources = ResourceSpecification.Builder.with().setVirtualCores(this.env.getWorkerCores()).setMemory(this.env.getWorkerMaxMemory(), ResourceSpecification.SizeUnit.MEGA).setInstances(this.env.getWorkerInstances()).build();
            return TwillSpecification.Builder.with().setName("fluo-app-" + this.env.getApplicationName()).withRunnable().add(FluoYarnLauncher.ORACLE_ID, (TwillRunnable)new BundledJarRunnable(), oracleResources).withLocalFiles().add(this.env.getBundledJarName(), new File(this.env.getBundledJarPath()), false).add(FluoYarnLauncher.CONN_PROPS, new File(this.env.getConnPropsPath()), false).add(FluoYarnLauncher.LOG4J_PROPS, new File(this.env.getLogPropsPath()), false).apply().add(FluoYarnLauncher.WORKER_ID, (TwillRunnable)new BundledJarRunnable(), workerResources).withLocalFiles().add(this.env.getBundledJarName(), new File(this.env.getBundledJarPath()), false).add(FluoYarnLauncher.CONN_PROPS, new File(this.env.getConnPropsPath()), false).add(FluoYarnLauncher.LOG4J_PROPS, new File(this.env.getLogPropsPath()), false).apply().anyOrder().build();
        }
    }
}

