/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor.operator;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorOperator;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorOperatorStateHandler;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorRequest;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.types.Either;
import org.apache.flink.util.function.SerializableSupplierWithException;

@Internal
public class CompactorOperatorStateHandlerFactory
extends AbstractStreamOperatorFactory<CommittableMessage<FileSinkCommittable>>
implements OneInputStreamOperatorFactory<Either<CommittableMessage<FileSinkCommittable>, CompactorRequest>, CommittableMessage<FileSinkCommittable>> {
    private final SerializableSupplierWithException<SimpleVersionedSerializer<FileSinkCommittable>, IOException> committableSerializerSupplier;
    private final SerializableSupplierWithException<BucketWriter<?, String>, IOException> bucketWriterProvider;

    public CompactorOperatorStateHandlerFactory(SerializableSupplierWithException<SimpleVersionedSerializer<FileSinkCommittable>, IOException> committableSerializerSupplier, SerializableSupplierWithException<BucketWriter<?, String>, IOException> bucketWriterProvider) {
        this.committableSerializerSupplier = committableSerializerSupplier;
        this.bucketWriterProvider = bucketWriterProvider;
    }

    @Override
    public <T extends StreamOperator<CommittableMessage<FileSinkCommittable>>> T createStreamOperator(StreamOperatorParameters<CommittableMessage<FileSinkCommittable>> parameters) {
        try {
            CompactorOperatorStateHandler handler = new CompactorOperatorStateHandler((SimpleVersionedSerializer)this.committableSerializerSupplier.get(), (BucketWriter)this.bucketWriterProvider.get());
            handler.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
            return (T)handler;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create commit operator for " + parameters.getStreamConfig().getOperatorName(), e);
        }
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return CompactorOperator.class;
    }
}

