/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Optional;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.scheduler.GlobalFailureHandler;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.slf4j.Logger;

interface State
extends GlobalFailureHandler {
    default public void onLeave(Class<? extends State> newState) {
    }

    public void cancel();

    public void suspend(Throwable var1);

    public JobStatus getJobStatus();

    public ArchivedExecutionGraph getJob();

    public Logger getLogger();

    default public <T> Optional<T> as(Class<? extends T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return Optional.of(clazz.cast(this));
        }
        return Optional.empty();
    }

    default public <T, E extends Exception> void tryRun(Class<? extends T> clazz, ThrowingConsumer<T, E> action, String debugMessage) throws E {
        Optional<T> asOptional = this.as(clazz);
        if (asOptional.isPresent()) {
            action.accept(asOptional.get());
        } else {
            this.getLogger().debug("Cannot run '{}' because the actual state is {} and not {}.", new Object[]{debugMessage, this.getClass().getSimpleName(), clazz.getSimpleName()});
        }
    }

    default public <T, V, E extends Exception> Optional<V> tryCall(Class<? extends T> clazz, FunctionWithException<T, V, E> action, String debugMessage) throws E {
        Optional<T> asOptional = this.as(clazz);
        if (asOptional.isPresent()) {
            return Optional.of(action.apply(asOptional.get()));
        }
        this.getLogger().debug("Cannot run '{}' because the actual state is {} and not {}.", new Object[]{debugMessage, this.getClass().getSimpleName(), clazz.getSimpleName()});
        return Optional.empty();
    }
}

