/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.OutputFormatFactory;
import org.apache.flink.core.fs.Path;

@Internal
public interface PartitionWriter<T> {
    public void write(T var1) throws Exception;

    public void close() throws Exception;

    public static class Context<T> {
        private final Configuration conf;
        private final OutputFormatFactory<T> factory;

        public Context(Configuration conf, OutputFormatFactory<T> factory) {
            this.conf = conf;
            this.factory = factory;
        }

        OutputFormat<T> createNewOutputFormat(Path path) throws IOException {
            OutputFormat<T> format = this.factory.createOutputFormat(path);
            format.configure(this.conf);
            format.open(0, 1);
            return format;
        }
    }
}

