/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.table.sink.FileCommittable;
import org.apache.flink.table.store.table.sink.FileCommittableSerializer;

public class SerializableCommittable
implements Serializable {
    private static final ThreadLocal<FileCommittableSerializer> CACHE = ThreadLocal.withInitial(FileCommittableSerializer::new);
    private transient FileCommittable committable;

    public FileCommittable delegate() {
        return this.committable;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        FileCommittableSerializer serializer = CACHE.get();
        out.writeInt(serializer.getVersion());
        SerializationUtils.serializeBytes(new DataOutputViewStreamWrapper(out), serializer.serialize(this.committable));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
        byte[] bytes = SerializationUtils.deserializedBytes(new DataInputViewStreamWrapper(in));
        this.committable = CACHE.get().deserialize(version, bytes);
    }

    public static SerializableCommittable wrap(FileCommittable committable) {
        SerializableCommittable ret = new SerializableCommittable();
        ret.committable = committable;
        return ret;
    }
}

