/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;

public class SequenceGenerator {
    private final int index;
    private final Generator generator;

    public SequenceGenerator(String field, RowType rowType) {
        this.index = rowType.getFieldNames().indexOf(field);
        if (this.index == -1) {
            throw new RuntimeException(String.format("Can not find sequence field %s in table schema: %s", field, rowType));
        }
        this.generator = (Generator)rowType.getTypeAt(this.index).accept((LogicalTypeVisitor)new SequenceGeneratorVisitor());
    }

    public long generate(RowData row) {
        return this.generator.generate(row, this.index);
    }

    private static class SequenceGeneratorVisitor
    extends LogicalTypeDefaultVisitor<Generator> {
        private SequenceGeneratorVisitor() {
        }

        public Generator visit(CharType charType) {
            return this.stringGenerator();
        }

        public Generator visit(VarCharType varCharType) {
            return this.stringGenerator();
        }

        private Generator stringGenerator() {
            return (row, i) -> Long.parseLong(row.getString(i).toString());
        }

        public Generator visit(DecimalType decimalType) {
            return (row, i) -> RowDataUtils.castToIntegral(row.getDecimal(i, decimalType.getPrecision(), decimalType.getScale()));
        }

        public Generator visit(TinyIntType tinyIntType) {
            return RowData::getByte;
        }

        public Generator visit(SmallIntType smallIntType) {
            return RowData::getShort;
        }

        public Generator visit(IntType intType) {
            return RowData::getInt;
        }

        public Generator visit(BigIntType bigIntType) {
            return RowData::getLong;
        }

        public Generator visit(FloatType floatType) {
            return (row, i) -> (long)row.getFloat(i);
        }

        public Generator visit(DoubleType doubleType) {
            return (row, i) -> (long)row.getDouble(i);
        }

        public Generator visit(DateType dateType) {
            return RowData::getInt;
        }

        public Generator visit(TimestampType timestampType) {
            return (row, i) -> row.getTimestamp(i, timestampType.getPrecision()).getMillisecond();
        }

        public Generator visit(LocalZonedTimestampType localZonedTimestampType) {
            return (row, i) -> row.getTimestamp(i, localZonedTimestampType.getPrecision()).getMillisecond();
        }

        protected Generator defaultMethod(LogicalType logicalType) {
            throw new UnsupportedOperationException("Unsupported type: " + logicalType);
        }
    }

    private static interface Generator {
        public long generate(RowData var1, int var2);
    }
}

