/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.streaming.connectors.kafka.table;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.shaded.streaming.connectors.kafka.table.ReducingUpsertWriter;
import org.apache.flink.table.store.shaded.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.function.SerializableFunction;

class ReducingUpsertSink<WriterState>
implements Sink<RowData, Void, WriterState, Void> {
    private final Sink<RowData, ?, WriterState, ?> wrappedSink;
    private final DataType physicalDataType;
    private final int[] keyProjection;
    private final SinkBufferFlushMode bufferFlushMode;
    private final SerializableFunction<RowData, RowData> valueCopyFunction;

    ReducingUpsertSink(Sink<RowData, ?, WriterState, ?> wrappedSink, DataType physicalDataType, int[] keyProjection, SinkBufferFlushMode bufferFlushMode, SerializableFunction<RowData, RowData> valueCopyFunction) {
        this.wrappedSink = wrappedSink;
        this.physicalDataType = physicalDataType;
        this.keyProjection = keyProjection;
        this.bufferFlushMode = bufferFlushMode;
        this.valueCopyFunction = valueCopyFunction;
    }

    public SinkWriter<RowData, Void, WriterState> createWriter(Sink.InitContext context, List<WriterState> states) throws IOException {
        SinkWriter wrapperWriter = this.wrappedSink.createWriter(context, states);
        return new ReducingUpsertWriter(wrapperWriter, this.physicalDataType, this.keyProjection, this.bufferFlushMode, context.getProcessingTimeService(), (Function<RowData, RowData>)this.valueCopyFunction);
    }

    public Optional<SimpleVersionedSerializer<WriterState>> getWriterStateSerializer() {
        return this.wrappedSink.getWriterStateSerializer();
    }

    public Optional<Committer<Void>> createCommitter() throws IOException {
        return Optional.empty();
    }

    public Optional<GlobalCommitter<Void, Void>> createGlobalCommitter() throws IOException {
        return Optional.empty();
    }

    public Optional<SimpleVersionedSerializer<Void>> getCommittableSerializer() {
        return Optional.empty();
    }

    public Optional<SimpleVersionedSerializer<Void>> getGlobalCommittableSerializer() {
        return Optional.empty();
    }
}

