/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import java.nio.ByteBuffer;
import java.util.Objects;

public class LogOffsetCommittable {
    private final int bucket;
    private final long offset;

    public LogOffsetCommittable(int bucket, long offset) {
        this.bucket = bucket;
        this.offset = offset;
    }

    public int bucket() {
        return this.bucket;
    }

    public long offset() {
        return this.offset;
    }

    public byte[] toBytes() {
        return ByteBuffer.allocate(12).putInt(this.bucket).putLong(this.offset).array();
    }

    public static LogOffsetCommittable fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return new LogOffsetCommittable(buffer.getInt(), buffer.getLong());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogOffsetCommittable that = (LogOffsetCommittable)o;
        return this.bucket == that.bucket && this.offset == that.offset;
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.offset);
    }
}

