/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader;

import java.io.IOException;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapArrayVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapMapVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.ArrayColumnReader;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.ColumnReader;

public class MapColumnReader
implements ColumnReader<WritableColumnVector> {
    private final ArrayColumnReader keyReader;
    private final ArrayColumnReader valueReader;

    public MapColumnReader(ArrayColumnReader keyReader, ArrayColumnReader valueReader) {
        this.keyReader = keyReader;
        this.valueReader = valueReader;
    }

    public void readBatch(int total, ColumnVector column) throws IOException {
        HeapMapVector mapVector = (HeapMapVector)column;
        HeapArrayVector keyArrayColumnVector = new HeapArrayVector(total);
        HeapArrayVector valueArrayColumnVector = new HeapArrayVector(total);
        this.keyReader.readToVector(total, (WritableColumnVector)keyArrayColumnVector);
        this.valueReader.readToVector(total, (WritableColumnVector)valueArrayColumnVector);
        mapVector.setKeys(keyArrayColumnVector.getChild());
        mapVector.setValues(valueArrayColumnVector.getChild());
        mapVector.setOffsets(keyArrayColumnVector.getOffsets());
        mapVector.setLengths(keyArrayColumnVector.getLengths());
        mapVector.setSize(keyArrayColumnVector.getSize());
        for (int i = 0; i < keyArrayColumnVector.getLen(); ++i) {
            if (!keyArrayColumnVector.isNullAt(i)) continue;
            mapVector.setNullAt(i);
        }
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        this.readBatch(readNumber, (ColumnVector)vector);
    }
}

