/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.broadcast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.iteration.compile.DraftExecutionEnvironment;
import org.apache.flink.ml.common.broadcast.operator.BroadcastVariableReceiverOperatorFactory;
import org.apache.flink.ml.common.broadcast.operator.BroadcastWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.MultipleConnectedStreams;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.AbstractMultipleInputTransformation;
import org.apache.flink.streaming.api.transformations.MultipleInputTransformation;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class BroadcastUtils {
    public static <OUT> DataStream<OUT> withBroadcastStream(List<DataStream<?>> inputList, Map<String, DataStream<?>> bcStreams, Function<List<DataStream<?>>, DataStream<OUT>> userDefinedFunction) {
        boolean canCoLocate;
        Preconditions.checkArgument((inputList.size() > 0 ? 1 : 0) != 0);
        StreamExecutionEnvironment env = inputList.get(0).getExecutionEnvironment();
        String[] broadcastNames = new String[bcStreams.size()];
        DataStream[] broadcastInputs = new DataStream[bcStreams.size()];
        TypeInformation[] broadcastInTypes = new TypeInformation[bcStreams.size()];
        int idx = 0;
        String broadcastId = new AbstractID().toHexString();
        for (String name : bcStreams.keySet()) {
            broadcastNames[idx] = broadcastId + "-" + name;
            broadcastInputs[idx] = bcStreams.get(name);
            broadcastInTypes[idx] = broadcastInputs[idx].getType();
            ++idx;
        }
        DataStream<OUT> resultStream = BroadcastUtils.getResultStream(env, inputList, broadcastNames, userDefinedFunction);
        TypeInformation outType = resultStream.getType();
        String coLocationKey = "broadcast-co-location-" + UUID.randomUUID();
        DataStream<OUT> cachedBroadcastInputs = BroadcastUtils.cacheBroadcastVariables(env, broadcastNames, broadcastInputs, broadcastInTypes, resultStream.getParallelism(), outType);
        boolean bl = canCoLocate = cachedBroadcastInputs.getTransformation() instanceof PhysicalTransformation && resultStream.getTransformation() instanceof PhysicalTransformation;
        if (!canCoLocate) {
            throw new UnsupportedOperationException("cannot set chaining strategy on " + cachedBroadcastInputs.getTransformation() + " and " + resultStream.getTransformation() + ".");
        }
        ((PhysicalTransformation)cachedBroadcastInputs.getTransformation()).setChainingStrategy(ChainingStrategy.HEAD);
        ((PhysicalTransformation)resultStream.getTransformation()).setChainingStrategy(ChainingStrategy.HEAD);
        cachedBroadcastInputs.getTransformation().setCoLocationGroupKey(coLocationKey);
        resultStream.getTransformation().setCoLocationGroupKey(coLocationKey);
        return cachedBroadcastInputs.union(new DataStream[]{resultStream});
    }

    private static <OUT> DataStream<OUT> cacheBroadcastVariables(StreamExecutionEnvironment env, String[] broadcastInputNames, DataStream<?>[] broadcastInputs, TypeInformation<?>[] broadcastInTypes, int parallelism, TypeInformation<OUT> outType) {
        MultipleInputTransformation transformation = new MultipleInputTransformation("broadcastInputs", new BroadcastVariableReceiverOperatorFactory(broadcastInputNames, broadcastInTypes), outType, parallelism);
        for (DataStream<?> dataStream : broadcastInputs) {
            transformation.addInput(dataStream.broadcast().getTransformation());
        }
        env.addOperator((Transformation)transformation);
        return new MultipleConnectedStreams(env).transform((AbstractMultipleInputTransformation)transformation);
    }

    private static <OUT> DataStream<OUT> getResultStream(StreamExecutionEnvironment env, List<DataStream<?>> inputList, String[] broadcastStreamNames, Function<List<DataStream<?>>, DataStream<OUT>> graphBuilder) {
        TypeInformation[] inTypes = new TypeInformation[inputList.size()];
        for (int i = 0; i < inputList.size(); ++i) {
            inTypes[i] = inputList.get(i).getType();
        }
        boolean[] isBlocked = new boolean[inputList.size()];
        Arrays.fill(isBlocked, false);
        DraftExecutionEnvironment draftEnv = new DraftExecutionEnvironment(env, new BroadcastWrapper(broadcastStreamNames, inTypes, isBlocked));
        ArrayList draftSources = new ArrayList();
        for (DataStream<?> dataStream : inputList) {
            draftSources.add(draftEnv.addDraftSource(dataStream, dataStream.getType()));
        }
        DataStream<OUT> draftOutStream = graphBuilder.apply(draftSources);
        Preconditions.checkState((draftEnv.getStreamGraph(false).getStreamNodes().size() == 1 + inputList.size() ? 1 : 0) != 0, (Object)"cannot add more than one operator in withBroadcastStream's lambda function.");
        draftEnv.copyToActualEnvironment();
        return draftEnv.getActualStream(draftOutStream.getId());
    }
}

