/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.builder;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.builder.TableId;
import org.apache.flink.util.Preconditions;

public class GraphNode {
    public final int nodeId;
    @Nullable
    public Stage<?> stage;
    public final StageType stageType;
    @Nullable
    public final TableId[] estimatorInputIds;
    public final TableId[] algoOpInputIds;
    public final TableId[] outputIds;
    @Nullable
    public TableId[] inputModelDataIds;
    @Nullable
    public TableId[] outputModelDataIds;

    public GraphNode(int nodeId, Stage<?> stage, StageType stageType, TableId[] estimatorInputIds, TableId[] algoOpInputIds, TableId[] outputIds, TableId[] inputModelDataIds, TableId[] outputModelDataIds) {
        this.nodeId = (Integer)Preconditions.checkNotNull((Object)nodeId);
        this.stage = stage;
        this.stageType = (StageType)((Object)Preconditions.checkNotNull((Object)((Object)stageType)));
        this.estimatorInputIds = estimatorInputIds;
        this.algoOpInputIds = (TableId[])Preconditions.checkNotNull((Object)algoOpInputIds);
        this.outputIds = (TableId[])Preconditions.checkNotNull((Object)outputIds);
        this.inputModelDataIds = inputModelDataIds;
        this.outputModelDataIds = outputModelDataIds;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("nodeId", this.nodeId);
        result.put("stageType", this.stageType.name());
        if (this.estimatorInputIds != null) {
            result.put("estimatorInputIds", TableId.toList(this.estimatorInputIds));
        }
        result.put("algoOpInputIds", TableId.toList(this.algoOpInputIds));
        result.put("outputIds", TableId.toList(this.outputIds));
        if (this.inputModelDataIds != null) {
            result.put("inputModelDataIds", TableId.toList(this.inputModelDataIds));
        }
        if (this.outputModelDataIds != null) {
            result.put("outputModelDataIds", TableId.toList(this.outputModelDataIds));
        }
        return result;
    }

    public static GraphNode fromMap(Map<String, Object> map) {
        int nodeId = (Integer)map.get("nodeId");
        StageType stageType = StageType.valueOf((String)map.get("stageType"));
        TableId[] estimatorInputIds = null;
        if (map.containsKey("estimatorInputIds")) {
            estimatorInputIds = TableId.fromList((List)map.get("estimatorInputIds"));
        }
        TableId[] algoOpInputIds = TableId.fromList((List)map.get("algoOpInputIds"));
        TableId[] outputIds = TableId.fromList((List)map.get("outputIds"));
        TableId[] inputModelDataIds = null;
        if (map.containsKey("inputModelDataIds")) {
            inputModelDataIds = TableId.fromList((List)map.get("inputModelDataIds"));
        }
        TableId[] outputModelDataIds = null;
        if (map.containsKey("outputModelDataIds")) {
            outputModelDataIds = TableId.fromList((List)map.get("outputModelDataIds"));
        }
        return new GraphNode(nodeId, null, stageType, estimatorInputIds, algoOpInputIds, outputIds, inputModelDataIds, outputModelDataIds);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphNode)) {
            return false;
        }
        GraphNode other = (GraphNode)obj;
        return this.nodeId == other.nodeId;
    }

    public int hashCode() {
        return Objects.hashCode(this.nodeId);
    }

    public String toString() {
        return String.format("GraphNode(nodeId=%d, stageType=%s, estimatorInputIds=%s, algoOpInputIds=%s, outputIds=%s, inputModelDataIds=%s, outputModelDataIds=%s)", this.nodeId, this.stageType.name(), Arrays.toString(this.estimatorInputIds), Arrays.toString(this.algoOpInputIds), Arrays.toString(this.outputIds), Arrays.toString(this.inputModelDataIds), Arrays.toString(this.outputModelDataIds));
    }

    public static enum StageType {
        ESTIMATOR,
        ALGO_OPERATOR;

    }
}

