/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import org.apache.flink.ml.feature.normalizer.Normalizer;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class NormalizerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 3.1, 1.2, 3.1, 4.6})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{1.2, 3.1, 4.6, 2.1, 3.1})})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("inputVec", new String[0]);
        Normalizer normalizer = (Normalizer)((Normalizer)((Normalizer)new Normalizer().setInputCol("inputVec")).setP(Double.valueOf(3.0))).setOutputCol("outputVec");
        Table outputTable = normalizer.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Vector inputValue = (Vector)row.getField(normalizer.getInputCol());
            Vector outputValue = (Vector)row.getField(normalizer.getOutputCol());
            System.out.printf("Input Value: %s \tOutput Value: %s\n", inputValue, outputValue);
        }
    }
}

