/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.types.remote;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.core.types.remote.RemoteValueSerializerSnapshot;
import org.apache.flink.statefun.sdk.TypeName;

final class RemoteValueSerializer
extends TypeSerializer<byte[]> {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY = new byte[0];
    private final TypeName type;

    public RemoteValueSerializer(TypeName type) {
        this.type = Objects.requireNonNull(type);
    }

    public TypeName getType() {
        return this.type;
    }

    public boolean isImmutableType() {
        return false;
    }

    public byte[] createInstance() {
        return EMPTY;
    }

    public byte[] copy(byte[] from) {
        byte[] copy = new byte[from.length];
        System.arraycopy(from, 0, copy, 0, from.length);
        return copy;
    }

    public byte[] copy(byte[] from, byte[] reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(byte[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        target.write(record);
    }

    public byte[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        byte[] result = new byte[len];
        source.readFully(result);
        return result;
    }

    public byte[] deserialize(byte[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len);
    }

    public TypeSerializer<byte[]> duplicate() {
        return new RemoteValueSerializer(this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || RemoteValueSerializer.class != o.getClass()) {
            return false;
        }
        RemoteValueSerializer that = (RemoteValueSerializer)((Object)o);
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public TypeSerializerSnapshot<byte[]> snapshotConfiguration() {
        return new RemoteValueSerializerSnapshot(this.type);
    }
}

