/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.feedback;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.agents.runtime.feedback.FeedbackChannel;
import org.apache.flink.agents.runtime.feedback.LockFreeBatchFeedbackQueue;
import org.apache.flink.agents.runtime.feedback.SubtaskFeedbackKey;

public final class FeedbackChannelBroker {
    private static final FeedbackChannelBroker INSTANCE = new FeedbackChannelBroker();
    private final ConcurrentHashMap<SubtaskFeedbackKey<?>, FeedbackChannel<?>> channels = new ConcurrentHashMap();

    public static FeedbackChannelBroker get() {
        return INSTANCE;
    }

    public <V> FeedbackChannel<V> getChannel(SubtaskFeedbackKey<V> key) {
        Objects.requireNonNull(key);
        FeedbackChannel channel = this.channels.computeIfAbsent(key, FeedbackChannelBroker::newChannel);
        return channel;
    }

    void removeChannel(SubtaskFeedbackKey<?> key) {
        this.channels.remove(key);
    }

    private static <V> FeedbackChannel<V> newChannel(SubtaskFeedbackKey<V> key) {
        LockFreeBatchFeedbackQueue queue = new LockFreeBatchFeedbackQueue();
        return new FeedbackChannel<V>(key, queue);
    }
}

