/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.tools;

import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ToolMetadata {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_INPUT_SCHEMA = "inputSchema";
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="inputSchema")
    private final String inputSchema;

    @JsonCreator
    public ToolMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="inputSchema") String inputSchema) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.description = Objects.requireNonNull(description, "description cannot be null");
        this.inputSchema = Objects.requireNonNull(inputSchema, "inputSchema cannot be null");
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInputSchema() {
        return this.inputSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolMetadata that = (ToolMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.inputSchema, that.inputSchema);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.inputSchema);
    }

    public String toString() {
        return String.format("ToolMetadata{name='%s', description='%s'}", this.name, this.description);
    }
}

