/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.fxg.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flex.compiler.fxg.dom.IFXGNode;
import org.apache.flex.compiler.internal.fxg.dom.GraphicNode;
import org.apache.flex.compiler.problems.FXGInvalidNodeAttributeProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;

public class DelegateNode
implements IFXGNode {
    protected String name;
    protected IFXGNode delegate;
    protected IFXGNode documentNode;
    protected String uri;
    protected int startLine;
    protected int startColumn;
    protected int endLine;
    protected int endColumn;

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    public void setDelegate(IFXGNode delegate, Collection<ICompilerProblem> problems) {
        this.delegate = delegate;
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        this.delegate.addChild(child, problems);
    }

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(this.delegate.getChildren());
        return children;
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        problems.add(new FXGInvalidNodeAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), name, this.getNodeName()));
    }

    @Override
    public IFXGNode getDocumentNode() {
        return this.documentNode;
    }

    @Override
    public void setDocumentNode(IFXGNode root) {
        this.documentNode = root;
    }

    @Override
    public String getNodeURI() {
        return this.uri;
    }

    public void setNodeURI(String uri) {
        this.uri = uri;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public void setStartLine(int line) {
        this.startLine = line;
    }

    @Override
    public int getStartColumn() {
        return this.startColumn;
    }

    @Override
    public void setStartColumn(int column) {
        this.startColumn = column;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public void setEndLine(int line) {
        this.endLine = line;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public void setEndColumn(int column) {
        this.endColumn = column;
    }

    @Override
    public String getDocumentPath() {
        return ((GraphicNode)this.getDocumentNode()).getDocumentPath();
    }
}

