/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.definitions.metadata;

import java.util.Collection;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.flex.compiler.internal.definitions.metadata.MetaTag;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.resourcebundles.ResourceBundleUtils;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.units.ICompilationUnit;

public class ResourceBundleMetaTag
extends MetaTag {
    private String bundleName;

    public ResourceBundleMetaTag(IDefinition decoratedDefinition, String tagName, IMetaTagAttribute[] attributes, String bundleName) {
        super(decoratedDefinition, tagName, attributes);
        this.bundleName = bundleName;
    }

    public void resolveDependencies(Collection<ICompilerProblem> errors, ICompilerProject project) throws InterruptedException {
        if (project instanceof FlexProject) {
            ICompilationUnit refCompUnit = ((FlexProject)project).getScope().getCompilationUnitForScope(this.getDecoratedDefinition().getContainingScope());
            assert (refCompUnit != null);
            ResourceBundleUtils.resolveDependencies(this.bundleName, refCompUnit, project, this, errors);
        }
    }
}

