/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.swf.tags.DefineSound;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoundTranscoder
extends AbstractTranscoder {
    private static final int[][] mp3frequencies = new int[][]{{11025, 0, 22050, 44100}, {12000, 0, 24000, 48000}, {8000, 0, 16000, 32000}, {0, 0, 0, 0}};
    private static final int[][] mp3bitrates = new int[][]{{0, 0, 0, 0, 0}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-1, -1, -1, -1, -1}};
    private static final int[][] mp3bitrateIndices = new int[][]{{-1, 4, 4, 3}, {-1, -1, -1, -1}, {-1, 4, 4, 3}, {-1, 2, 1, 0}};

    public SoundTranscoder() {
        super(new String[]{"audio/mpeg"}, DefineSound.class, true);
    }

    @Override
    public boolean isSupportedAttribute(String attr) {
        return false;
    }

    @Override
    public Transcoder.TranscodingResults doTranscode(PathResolver context, SymbolTable symbolTable, Map<String, Object> args, String className, boolean generateSource) throws TranscoderException {
        Transcoder.TranscodingResults results = new Transcoder.TranscodingResults(this.resolveSource(context, args));
        String newName = (String)args.get("exportSymbol");
        results.defineTag = this.mp3(results.assetSource, newName);
        if (generateSource) {
            this.generateSource(results, className, args);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DefineSound mp3(VirtualFile source, String symbolName) throws TranscoderException {
        byte[] sound;
        block13: {
            InputStream in = null;
            sound = null;
            try {
                try {
                    int size = (int)source.size();
                    in = source.getInputStream();
                    sound = this.readFully(in, size);
                }
                catch (IOException ex) {
                    throw new AbstractTranscoder.ExceptionWhileTranscoding(ex);
                }
                Object var7_8 = null;
                if (in == null) break block13;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            in.close();
        }
        if (sound == null) throw new NotInMP3Format();
        if (sound.length < 5) {
            throw new NotInMP3Format();
        }
        DefineSound ds = new DefineSound();
        ds.format = 2;
        ds.data = sound;
        ds.size = 1;
        ds.name = symbolName;
        int version = ds.data[3] >> 3 & 3;
        int layer = ds.data[3] >> 1 & 3;
        int samplingRate = ds.data[4] >> 2 & 3;
        int channelMode = ds.data[5] >> 6 & 3;
        int frequency = mp3frequencies[samplingRate][version];
        switch (frequency) {
            case 11025: {
                ds.rate = 1;
                break;
            }
            case 22050: {
                ds.rate = 2;
                break;
            }
            case 44100: {
                ds.rate = 3;
                break;
            }
            default: {
                throw new UnsupportedSamplingRate(frequency);
            }
        }
        ds.type = channelMode == 3 ? 0 : 1;
        ds.sampleCount = this.countFrames(ds.data) * (layer == 3 ? 384 : 1152);
        if (ds.sampleCount >= 0L) return ds;
        throw new CouldNotDetermineSampleFrameCount();
    }

    private byte[] readFully(InputStream inputStream, int size) throws IOException {
        int b;
        BufferedInputStream in = new BufferedInputStream(inputStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size + 2);
        baos.write(0);
        baos.write(0);
        int state = 0;
        while ((b = in.read()) != -1) {
            if (state == 0) {
                if (b != 255) continue;
                state = 1;
                continue;
            }
            if (state == 1) {
                if ((b >> 5 & 7) == 7) {
                    baos.write(255);
                    baos.write(b);
                    state = 2;
                    continue;
                }
                state = 0;
                continue;
            }
            if (state != 2) continue;
            baos.write(b);
        }
        return baos.toByteArray();
    }

    private int countFrames(byte[] data) {
        int count = 0;
        int start = 2;
        boolean skipped = false;
        while (start + 2 < data.length) {
            int frameLength;
            int bitrate;
            int b1 = data[start] & 0xFF;
            int b2 = data[start + 1] & 0xFF;
            int b3 = data[start + 2] & 0xFF;
            if (b1 != 255 || (b2 >> 5 & 7) != 7) {
                if (!skipped && start > 0) {
                    b3 = b2;
                    b2 = b1;
                    b1 = data[start - 1] & 0xFF;
                    if (b1 != 255 || (b2 >> 5 & 7) != 7) {
                        ++start;
                        continue;
                    }
                    --start;
                } else {
                    ++start;
                    continue;
                }
            }
            int version = b2 >> 3 & 3;
            int layer = b2 >> 1 & 3;
            int bits = b3 >> 4 & 0xF;
            int bitrateIndex = mp3bitrateIndices[version][layer];
            int n = bitrate = bitrateIndex != -1 ? mp3bitrates[bits][bitrateIndex] * 1000 : -1;
            if (bitrate == -1) {
                skipped = true;
                ++start;
                continue;
            }
            int samplingRate = b3 >> 2 & 3;
            int frequency = mp3frequencies[samplingRate][version];
            if (frequency == 0) {
                skipped = true;
                ++start;
                continue;
            }
            int padding = b3 >> 1 & 1;
            int n2 = frameLength = layer == 3 ? (12 * bitrate / frequency + padding) * 4 : 144 * bitrate / frequency + padding;
            if (frameLength == 0) break;
            start += frameLength;
            skipped = false;
            ++count;
        }
        return count;
    }

    public static final class NotInMP3Format
    extends TranscoderException {
        private static final long serialVersionUID = -2480509003403956321L;
    }

    public static final class UnsupportedSamplingRate
    extends TranscoderException {
        private static final long serialVersionUID = -7440513635414375590L;
        public int frequency;

        public UnsupportedSamplingRate(int frequency) {
            this.frequency = frequency;
        }
    }

    public static final class CouldNotDetermineSampleFrameCount
    extends TranscoderException {
        private static final long serialVersionUID = 6530096120116320212L;
    }
}

