/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package flex2.compiler.css;

import flex2.compiler.util.CompilerMessage.CompilerWarning;

/**
 * Warning used to report when a type selector is not fully qualified.
 */
public class UnqualifiedTypeSelector extends CompilerWarning
{
    private static final long serialVersionUID = -6014148964083571460L;
    public String selector;
    public String type;

    public UnqualifiedTypeSelector(String path, int line, String type, String selector)
    {
        this.path = path;
        this.line = line;
        this.type = type;
        this.selector = selector;
    }

}