/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.provides;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.composite.service.provides.MethodMetadata;
import org.apache.felix.ipojo.composite.service.provides.ProvidedServiceHandler;
import org.osgi.framework.BundleContext;

public class SpecificationMetadata {
    private String m_name;
    private List m_methods = new ArrayList();
    private boolean m_isAggregate;
    private boolean m_isOptional = false;
    private boolean m_isInterface = true;
    private String m_componentType = null;
    private ProvidedServiceHandler m_handler;

    public SpecificationMetadata(String name, BundleContext context, boolean isAggregate, boolean isOptional, ProvidedServiceHandler psd) {
        this.m_name = name;
        this.m_handler = psd;
        try {
            Class clazz = context.getBundle().loadClass(name);
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                MethodMetadata method = new MethodMetadata(methods[i]);
                this.m_methods.add(method);
            }
        }
        catch (ClassNotFoundException e) {
            this.m_handler.error("Cannot open " + name + " : " + e.getMessage());
            return;
        }
        this.m_isAggregate = isAggregate;
        this.m_isOptional = isOptional;
    }

    public SpecificationMetadata(Class clazz, String type, ProvidedServiceHandler psd) {
        this.m_handler = psd;
        this.m_isAggregate = false;
        this.m_isOptional = false;
        this.m_componentType = type;
        this.m_name = clazz.getName();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodMetadata method = new MethodMetadata(methods[i]);
            this.m_methods.add(method);
        }
        this.m_isInterface = false;
    }

    public String getName() {
        return this.m_name;
    }

    public List getMethods() {
        return this.m_methods;
    }

    public MethodMetadata getMethodByName(String name) {
        for (int i = 0; i < this.m_methods.size(); ++i) {
            MethodMetadata met = (MethodMetadata)this.m_methods.get(i);
            if (!met.getMethod().getName().equals(name)) continue;
            return met;
        }
        return null;
    }

    public boolean isAggregate() {
        return this.m_isAggregate;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public boolean isInterface() {
        return this.m_isInterface;
    }

    public void setIsOptional(boolean optional) {
        this.m_isOptional = optional;
    }

    public String getComponentType() {
        return this.m_componentType;
    }
}

