/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.instantiator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.PolicyServiceContext;
import org.apache.felix.ipojo.composite.service.instantiator.ServiceDependencyHandler;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceImporter
extends DependencyModel {
    private ServiceDependencyHandler m_handler;
    private List m_records = new ArrayList();
    private String m_id;
    private boolean m_specLevelReq;
    private boolean m_isFrozen;

    public ServiceImporter(Class specification, Filter filter, boolean multiple, boolean optional, Comparator cmp, int policy, BundleContext context, String identitity, ServiceDependencyHandler handler) {
        super(specification, multiple, optional, filter, cmp, policy, context, (DependencyStateListener)handler, (ComponentInstance)handler.getCompositeManager());
        this.m_handler = handler;
        this.m_id = this.m_id == null ? super.getSpecification().getName() : identitity;
    }

    private static Dictionary getProps(ServiceReference ref) {
        Properties prop = new Properties();
        String[] keys = ref.getPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            prop.put(keys[i], ref.getProperty(keys[i]));
        }
        return prop;
    }

    public void freeze() {
        this.m_isFrozen = true;
    }

    public void unfreeze() {
        this.m_isFrozen = false;
    }

    public boolean isFrozen() {
        return this.m_isFrozen;
    }

    public void stop() {
        super.stop();
        for (int i = 0; i < this.m_records.size(); ++i) {
            Record rec = (Record)this.m_records.get(i);
            rec.dispose();
        }
        this.m_records.clear();
    }

    private List getRecordsByRef(ServiceReference ref) {
        ArrayList<Record> list = new ArrayList<Record>();
        for (int i = 0; i < this.m_records.size(); ++i) {
            Record rec = (Record)this.m_records.get(i);
            if (rec.m_ref != ref) continue;
            list.add(rec);
        }
        return list;
    }

    public List getProviders() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.m_records.size(); ++i) {
            list.add(((Record)this.m_records.get(i)).m_ref.getProperty("instance.name"));
        }
        return list;
    }

    public void setServiceLevelDependency() {
        this.m_specLevelReq = true;
        PolicyServiceContext context = new PolicyServiceContext(this.m_handler.getCompositeManager().getGlobalContext(), this.m_handler.getCompositeManager().getParentServiceContext(), 0);
        this.setBundleContext((BundleContext)context);
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isServiceLevelRequirement() {
        return this.m_specLevelReq;
    }

    public void onDependencyReconfiguration(ServiceReference[] departs, ServiceReference[] arrivals) {
        int i;
        for (i = 0; departs != null && i < departs.length; ++i) {
            this.onServiceDeparture(departs[i]);
        }
        for (i = 0; arrivals != null && i < arrivals.length; ++i) {
            this.onServiceArrival(arrivals[i]);
        }
    }

    public void onServiceArrival(ServiceReference ref) {
        Record rec = new Record(ref);
        this.m_records.add(rec);
        rec.register();
    }

    public void onServiceDeparture(ServiceReference ref) {
        List list = this.getRecordsByRef(ref);
        for (int i = 0; i < list.size(); ++i) {
            Record rec = (Record)list.get(i);
            rec.dispose();
        }
        this.m_records.removeAll(list);
    }

    public void onServiceModification(ServiceReference ref) {
        List list = this.getRecordsByRef(ref);
        for (int i = 0; i < list.size(); ++i) {
            Record rec = (Record)list.get(i);
            rec.update();
        }
    }

    private final class Record {
        private ServiceReference m_ref;
        private ServiceRegistration m_reg;
        private Object m_svcObject;

        protected Record(ServiceReference ref) {
            this.m_ref = ref;
        }

        private void register() {
            if (this.m_reg != null) {
                this.m_reg.unregister();
            }
            this.m_svcObject = ServiceImporter.this.getService(this.m_ref);
            this.m_reg = ServiceImporter.this.m_handler.getCompositeManager().getServiceContext().registerService(ServiceImporter.this.getSpecification().getName(), this.m_svcObject, ServiceImporter.getProps(this.m_ref));
        }

        private void update() {
            if (this.m_reg != null) {
                this.m_reg.setProperties(ServiceImporter.getProps(this.m_ref));
            }
        }

        private void dispose() {
            if (this.m_reg != null) {
                this.m_reg.unregister();
                this.m_svcObject = null;
                this.m_reg = null;
            }
            this.m_ref = null;
        }

        public boolean equals(Object object) {
            if (object instanceof Record) {
                Record rec = (Record)object;
                return rec.m_ref == this.m_ref;
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

