/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.cometd.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServlet;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.cometd.CometdService;
import org.apache.felix.http.cometd.internal.CometdConfig;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.server.CometdServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class CometdServiceImpl
extends HttpServlet
implements ManagedService,
ServiceTrackerCustomizer,
CometdService {
    private static final long serialVersionUID = 1L;
    private static final String PID = "org.apache.felix.http.cometd";
    private final CometdConfig config;
    private final BundleContext context;
    private ServiceRegistration configServiceReg;
    private ServiceTracker httpServiceTracker;
    private ServiceRegistration cometdServiceReg;
    private CometdServlet continuationCometdServlet;

    public CometdServiceImpl(BundleContext context) {
        this.context = context;
        this.config = new CometdConfig(this.context);
    }

    public void start() throws Exception {
        Properties props = new Properties();
        props.put("service.pid", PID);
        this.configServiceReg = this.context.registerService(ManagedService.class.getName(), (Object)this, (Dictionary)props);
        this.httpServiceTracker = new ServiceTracker(this.context, HttpService.class.getName(), (ServiceTrackerCustomizer)this);
        this.httpServiceTracker.open();
    }

    public void stop() throws Exception {
        if (this.configServiceReg != null) {
            this.configServiceReg.unregister();
        }
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
        }
    }

    public void updated(Dictionary props) {
        Object service;
        this.config.update(props);
        if (this.httpServiceTracker != null && (service = this.httpServiceTracker.getService()) != null) {
            this.unregister((HttpService)service);
            this.register((HttpService)service);
        }
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        this.register((HttpService)service);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.unregister((HttpService)service);
        this.register((HttpService)service);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.unregister((HttpService)service);
    }

    private void register(HttpService httpService) {
        if (this.continuationCometdServlet == null) {
            this.continuationCometdServlet = new CometdServlet();
        }
        try {
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("requestAvailable", "true");
            httpService.registerServlet(this.config.getPath(), this.continuationCometdServlet, dictionary, null);
        }
        catch (Exception e) {
            SystemLogger.error("Failed to register ContinuationCometdServlet to " + this.config.getPath(), e);
        }
        this.cometdServiceReg = this.context.registerService(CometdService.class.getName(), (Object)this, null);
    }

    private void unregister(HttpService httpService) {
        httpService.unregister(this.config.getPath());
        if (this.cometdServiceReg != null) {
            this.cometdServiceReg.unregister();
            this.cometdServiceReg = null;
        }
    }

    public BayeuxServer getBayeuxServer() {
        return this.continuationCometdServlet.getBayeux();
    }
}

