/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.HttpServiceController;
import org.apache.felix.http.base.internal.listener.ServletRequestAttributeListenerManager;
import org.apache.felix.http.base.internal.listener.ServletRequestListenerManager;

public final class DispatcherServlet
extends HttpServlet {
    private final HttpServiceController controller;

    public DispatcherServlet(HttpServiceController controller) {
        this.controller = controller;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.controller.register(this.getServletContext());
    }

    public void destroy() {
        this.controller.unregister();
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletRequestListenerManager requestListener = this.controller.getRequestListener();
        ServletRequestEvent sre = new ServletRequestEvent(this.getServletContext(), req);
        requestListener.requestInitialized(sre);
        try {
            req = new AttributeEventRequest(this.getServletContext(), this.controller.getRequestAttributeListener(), req);
            this.controller.getDispatcher().dispatch(req, res);
        }
        finally {
            requestListener.requestDestroyed(sre);
        }
    }

    private static class AttributeEventRequest
    extends HttpServletRequestWrapper {
        private final ServletContext servletContext;
        private final ServletRequestAttributeListenerManager listener;

        public AttributeEventRequest(ServletContext servletContext, ServletRequestAttributeListenerManager requestAttributeListener, HttpServletRequest request) {
            super(request);
            this.servletContext = servletContext;
            this.listener = requestAttributeListener;
        }

        public void setAttribute(String name, Object value) {
            if (value == null) {
                this.removeAttribute(name);
            } else if (name != null) {
                Object oldValue = this.getAttribute(name);
                super.setAttribute(name, value);
                if (oldValue == null) {
                    this.listener.attributeAdded(new ServletRequestAttributeEvent(this.servletContext, this, name, value));
                } else {
                    this.listener.attributeReplaced(new ServletRequestAttributeEvent(this.servletContext, this, name, oldValue));
                }
            }
        }

        public void removeAttribute(String name) {
            Object oldValue = this.getAttribute(name);
            super.removeAttribute(name);
            if (oldValue != null) {
                this.listener.attributeRemoved(new ServletRequestAttributeEvent(this.servletContext, this, name, oldValue));
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "->" + super.getRequest();
        }
    }
}

