/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorCursor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractOpenEditorAction
extends BrowserAction
implements FocusListener,
KeyListener {
    protected ValueEditorManager valueEditorManager;
    protected TableViewer viewer;
    protected SearchResultEditorCursor cursor;
    protected CellEditor cellEditor;
    private boolean isActive;
    protected SearchResultEditorActionGroup actionGroup;

    protected AbstractOpenEditorAction(TableViewer viewer, SearchResultEditorCursor cursor, ValueEditorManager valueEditorManager, SearchResultEditorActionGroup actionGroup) {
        this.viewer = viewer;
        this.cursor = cursor;
        this.valueEditorManager = valueEditorManager;
        this.actionGroup = actionGroup;
        this.isActive = false;
    }

    public CellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void run() {
        this.activateEditor();
    }

    private void activateEditor() {
        Object element = this.cursor.getRow().getData();
        String property = (String)this.viewer.getColumnProperties()[this.cursor.getColumn()];
        if (!this.viewer.isCellEditorActive() && this.viewer.getCellModifier().canModify(element, property)) {
            this.actionGroup.deactivateGlobalActionHandlers();
            int i = 0;
            while (i < this.viewer.getCellEditors().length) {
                this.viewer.getCellEditors()[i] = this.cellEditor;
                ++i;
            }
            if (this.cellEditor.getControl() != null) {
                this.cellEditor.getControl().addFocusListener((FocusListener)this);
                this.cellEditor.getControl().addKeyListener((KeyListener)this);
            }
            this.cursor.setVisible(false);
            this.isActive = true;
            this.viewer.editElement(element, this.cursor.getColumn());
            this.viewer.setSelection(null, true);
            this.viewer.getTable().setSelection(new TableItem[0]);
            if (!this.viewer.isCellEditorActive()) {
                this.editorClosed();
            }
        } else {
            this.valueEditorManager.setUserSelectedValueEditor(null);
        }
    }

    private void editorClosed() {
        this.isActive = false;
        int i = 0;
        while (i < this.viewer.getCellEditors().length) {
            this.viewer.getCellEditors()[i] = null;
            ++i;
        }
        if (this.cellEditor.getControl() != null) {
            this.cellEditor.getControl().removeFocusListener((FocusListener)this);
            this.cellEditor.getControl().removeKeyListener((KeyListener)this);
        }
        this.valueEditorManager.setUserSelectedValueEditor(null);
        this.cursor.setVisible(true);
        this.viewer.refresh();
        this.cursor.redraw();
        this.cursor.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractOpenEditorAction.this.cursor.setFocus();
            }
        });
        this.actionGroup.activateGlobalActionHandlers();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.editorClosed();
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '\u001b' && e.stateMask == 0) {
            e.doit = false;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public boolean isActive() {
        return this.isActive;
    }
}

