/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import org.apache.directory.server.config.beans.PasswordPolicyBean;
import org.apache.directory.studio.apacheds.configuration.editor.PasswordPoliciesMasterDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.editor.PasswordPoliciesPage;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditorUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PasswordPolicyDetailsPage
implements IDetailsPage {
    private PasswordPoliciesMasterDetailsBlock masterDetailsBlock;
    private IManagedForm mform;
    private PasswordPolicyBean passwordPolicy;
    private Button enabledCheckbox;
    private Text idText;
    private Text descriptionText;
    private ComboViewer checkQualityComboViewer;
    private Text validatorText;
    private Button minimumLengthCheckbox;
    private Text minimumLengthText;
    private Button maximumLengthCheckbox;
    private Text maximumLengthText;
    private Text minimumAgeText;
    private Text maximumAgeText;
    private Button expireWarningCheckbox;
    private Text expireWarningText;
    private Button graceAuthenticationLimitCheckbox;
    private Text graceAuthenticationLimitText;
    private Button graceExpireCheckbox;
    private Text graceExpireText;
    private Button mustChangeCheckbox;
    private Button allowUserChangeCheckbox;
    private Button safeModifyCheckbox;
    private Button lockoutCheckbox;
    private Text lockoutDurationText;
    private Text maxFailureText;
    private Text failureCountIntervalText;
    private Button inHistoryCheckbox;
    private Text inHistoryText;
    private Button maxIdleCheckbox;
    private Text maxIdleText;
    private Text minimumDelayText;
    private Text maximumDelayText;
    private ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            PasswordPolicyDetailsPage.this.commit(true);
            PasswordPolicyDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private SelectionListener buttonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PasswordPolicyDetailsPage.this.commit(true);
            PasswordPolicyDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private ISelectionChangedListener viewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PasswordPolicyDetailsPage.this.commit(true);
            PasswordPolicyDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private VerifyListener integerVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (!e.text.matches("[0-9]*")) {
                e.doit = false;
            }
        }
    };
    private ISelectionChangedListener checkQualityComboViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selection = (StructuredSelection)PasswordPolicyDetailsPage.this.checkQualityComboViewer.getSelection();
            if (!selection.isEmpty()) {
                CheckQuality checkQuality = (CheckQuality)((Object)selection.getFirstElement());
                if (checkQuality == CheckQuality.DISABLED) {
                    PasswordPolicyDetailsPage.this.minimumLengthCheckbox.setEnabled(false);
                    PasswordPolicyDetailsPage.this.minimumLengthText.setEnabled(false);
                    PasswordPolicyDetailsPage.this.maximumLengthCheckbox.setEnabled(false);
                    PasswordPolicyDetailsPage.this.maximumLengthText.setEnabled(false);
                } else {
                    int minimumLength = 0;
                    int maximumLength = 0;
                    try {
                        minimumLength = Integer.parseInt(PasswordPolicyDetailsPage.this.minimumLengthText.getText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    try {
                        maximumLength = Integer.parseInt(PasswordPolicyDetailsPage.this.maximumLengthText.getText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    PasswordPolicyDetailsPage.this.minimumLengthCheckbox.setEnabled(true);
                    PasswordPolicyDetailsPage.this.minimumLengthText.setEnabled(minimumLength != 0);
                    PasswordPolicyDetailsPage.this.maximumLengthCheckbox.setEnabled(true);
                    PasswordPolicyDetailsPage.this.maximumLengthText.setEnabled(maximumLength != 0);
                }
            }
        }
    };
    private SelectionListener minimumLengthCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PasswordPolicyDetailsPage.this.minimumLengthText.setEnabled(PasswordPolicyDetailsPage.this.minimumLengthCheckbox.getSelection());
        }
    };
    private SelectionListener maximumLengthCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PasswordPolicyDetailsPage.this.maximumLengthText.setEnabled(PasswordPolicyDetailsPage.this.maximumLengthCheckbox.getSelection());
        }
    };
    private SelectionListener expireWarningCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PasswordPolicyDetailsPage.this.expireWarningText.setEnabled(PasswordPolicyDetailsPage.this.expireWarningCheckbox.getSelection());
        }
    };
    private SelectionListener graceAuthenticationLimitCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PasswordPolicyDetailsPage.this.graceAuthenticationLimitText.setEnabled(PasswordPolicyDetailsPage.this.graceAuthenticationLimitCheckbox.getSelection());
        }
    };
    private SelectionListener graceExpireCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PasswordPolicyDetailsPage.this.graceExpireText.setEnabled(PasswordPolicyDetailsPage.this.graceExpireCheckbox.getSelection());
        }
    };
    private SelectionListener maxIdleCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PasswordPolicyDetailsPage.this.maxIdleText.setEnabled(PasswordPolicyDetailsPage.this.maxIdleCheckbox.getSelection());
        }
    };
    private SelectionListener inHistoryCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PasswordPolicyDetailsPage.this.inHistoryText.setEnabled(PasswordPolicyDetailsPage.this.inHistoryCheckbox.getSelection());
        }
    };

    public PasswordPolicyDetailsPage(PasswordPoliciesMasterDetailsBlock pmdb) {
        this.masterDetailsBlock = pmdb;
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.mform.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        this.createDetailsSection(toolkit, parent);
        this.createQualitySection(toolkit, parent);
        this.createExpirationSection(toolkit, parent);
        this.createOptionsSection(toolkit, parent);
        this.createLockoutSection(toolkit, parent);
    }

    private void createDetailsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText("Password Policy Details");
        section.setDescription("Set the properties of the password policy.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        this.enabledCheckbox = toolkit.createButton(client, "Enabled", 32);
        this.enabledCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(client, "ID:");
        this.idText = toolkit.createText(client, "");
        this.idText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client, "Description:");
        this.descriptionText = toolkit.createText(client, "");
        this.descriptionText.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createQualitySection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.marginWidth = 10;
        section.setText("Quality");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, "Check Quality:");
        this.checkQualityComboViewer = new ComboViewer(composite);
        this.checkQualityComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkQualityComboViewer.setInput((Object)new CheckQuality[]{CheckQuality.DISABLED, CheckQuality.RELAXED, CheckQuality.STRICT});
        this.checkQualityComboViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "Validator:");
        this.validatorText = toolkit.createText(composite, "");
        this.validatorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.minimumLengthCheckbox = toolkit.createButton(composite, "Enable Minimum Length", 32);
        this.minimumLengthCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Composite minimumLengthRadioIndentComposite = this.createRadioIndentComposite(toolkit, composite, "Number of characters:");
        this.minimumLengthText = toolkit.createText(minimumLengthRadioIndentComposite, "");
        this.minimumLengthText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maximumLengthCheckbox = toolkit.createButton(composite, "Enable Maximum Length", 32);
        this.maximumLengthCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Composite maximumLengthRadioIndentComposite = this.createRadioIndentComposite(toolkit, composite, "Number of characters:");
        this.maximumLengthText = toolkit.createText(maximumLengthRadioIndentComposite, "");
        this.maximumLengthText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createExpirationSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.marginWidth = 10;
        section.setText("Expiration");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, "Minimum Age (seconds):");
        this.minimumAgeText = toolkit.createText(composite, "");
        this.minimumAgeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "Maximum Age (seconds):");
        this.maximumAgeText = toolkit.createText(composite, "");
        this.maximumAgeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.expireWarningCheckbox = toolkit.createButton(composite, "Enable Expire Warning", 32);
        this.expireWarningCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        Composite expireWarningRadioIndentComposite = this.createRadioIndentComposite(toolkit, composite, "Number of seconds:");
        this.expireWarningText = toolkit.createText(expireWarningRadioIndentComposite, "");
        this.expireWarningText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.graceAuthenticationLimitCheckbox = toolkit.createButton(composite, "Enable Grace Authentication Limit", 32);
        this.graceAuthenticationLimitCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        Composite graceAuthenticationLimitRadioIndentComposite = this.createRadioIndentComposite(toolkit, composite, "Number of times:");
        this.graceAuthenticationLimitText = toolkit.createText(graceAuthenticationLimitRadioIndentComposite, "");
        this.graceAuthenticationLimitText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.graceExpireCheckbox = toolkit.createButton(composite, "Enable Grace Expire", 32);
        this.graceExpireCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        Composite graceExpireRadioIndentComposite = this.createRadioIndentComposite(toolkit, composite, "Interval (seconds):");
        this.graceExpireText = toolkit.createText(graceExpireRadioIndentComposite, "");
        this.graceExpireText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createOptionsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.marginWidth = 10;
        section.setText("Options");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        this.mustChangeCheckbox = toolkit.createButton(composite, "Enable Must Change", 32);
        this.mustChangeCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.allowUserChangeCheckbox = toolkit.createButton(composite, "Enable Allow User Change", 32);
        this.allowUserChangeCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.safeModifyCheckbox = toolkit.createButton(composite, "Enable Safe Modify", 32);
        this.safeModifyCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
    }

    private void createLockoutSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 256);
        section.marginWidth = 10;
        section.setText("Lockout");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        this.lockoutCheckbox = toolkit.createButton(composite, "Enable Lockout", 32);
        this.lockoutCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        toolkit.createLabel(composite, "Lockout Duration (seconds):");
        this.lockoutDurationText = toolkit.createText(composite, "");
        this.lockoutDurationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "Maximum Consecutive Failures (count):");
        this.maxFailureText = toolkit.createText(composite, "");
        this.maxFailureText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "Failure Count Interval (seconds):");
        this.failureCountIntervalText = toolkit.createText(composite, "");
        this.failureCountIntervalText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maxIdleCheckbox = toolkit.createButton(composite, "Enable Maximum Idle", 32);
        this.maxIdleCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        Composite maxIdleCheckboxRadioIndentComposite = this.createRadioIndentComposite(toolkit, composite, "Interval (seconds):");
        this.maxIdleText = toolkit.createText(maxIdleCheckboxRadioIndentComposite, "");
        this.maxIdleText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inHistoryCheckbox = toolkit.createButton(composite, "Enable In History", 32);
        this.inHistoryCheckbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Composite inHistoryRadioIndentComposite = this.createRadioIndentComposite(toolkit, composite, "Used passwords stored in history:");
        this.inHistoryText = toolkit.createText(inHistoryRadioIndentComposite, "");
        this.inHistoryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "Minimum Delay (seconds):");
        this.minimumDelayText = toolkit.createText(composite, "");
        this.minimumDelayText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(composite, "Maximum Delay (seconds):");
        this.maximumDelayText = toolkit.createText(composite, "");
        this.maximumDelayText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private Composite createRadioIndentComposite(FormToolkit toolkit, Composite parent, String text) {
        Composite composite = toolkit.createComposite(parent);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        toolkit.createLabel(composite, "   ");
        toolkit.createLabel(composite, text);
        return composite;
    }

    private void addListeners() {
        this.enabledCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.idText.addModifyListener(this.textModifyListener);
        this.descriptionText.addModifyListener(this.textModifyListener);
        this.checkQualityComboViewer.addSelectionChangedListener(this.viewerSelectionChangedListener);
        this.checkQualityComboViewer.addSelectionChangedListener(this.checkQualityComboViewerSelectionChangedListener);
        this.validatorText.addModifyListener(this.textModifyListener);
        this.minimumLengthCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.minimumLengthCheckbox.addSelectionListener(this.minimumLengthCheckboxSelectionListener);
        this.minimumLengthText.addModifyListener(this.textModifyListener);
        this.minimumLengthText.addVerifyListener(this.integerVerifyListener);
        this.maximumLengthCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.maximumLengthCheckbox.addSelectionListener(this.maximumLengthCheckboxSelectionListener);
        this.maximumLengthText.addModifyListener(this.textModifyListener);
        this.maximumLengthText.addVerifyListener(this.integerVerifyListener);
        this.minimumAgeText.addModifyListener(this.textModifyListener);
        this.minimumAgeText.addVerifyListener(this.integerVerifyListener);
        this.maximumAgeText.addModifyListener(this.textModifyListener);
        this.maximumAgeText.addVerifyListener(this.integerVerifyListener);
        this.expireWarningCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.expireWarningCheckbox.addSelectionListener(this.expireWarningCheckboxSelectionListener);
        this.expireWarningText.addModifyListener(this.textModifyListener);
        this.expireWarningText.addVerifyListener(this.integerVerifyListener);
        this.graceAuthenticationLimitCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.graceAuthenticationLimitCheckbox.addSelectionListener(this.graceAuthenticationLimitCheckboxSelectionListener);
        this.graceAuthenticationLimitText.addModifyListener(this.textModifyListener);
        this.graceAuthenticationLimitText.addVerifyListener(this.integerVerifyListener);
        this.graceExpireCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.graceExpireCheckbox.addSelectionListener(this.graceExpireCheckboxSelectionListener);
        this.graceExpireText.addModifyListener(this.textModifyListener);
        this.graceExpireText.addVerifyListener(this.integerVerifyListener);
        this.mustChangeCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.allowUserChangeCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.safeModifyCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.lockoutCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.lockoutDurationText.addModifyListener(this.textModifyListener);
        this.lockoutDurationText.addVerifyListener(this.integerVerifyListener);
        this.maxFailureText.addModifyListener(this.textModifyListener);
        this.maxFailureText.addVerifyListener(this.integerVerifyListener);
        this.failureCountIntervalText.addModifyListener(this.textModifyListener);
        this.failureCountIntervalText.addVerifyListener(this.integerVerifyListener);
        this.maxIdleCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.maxIdleCheckbox.addSelectionListener(this.maxIdleCheckboxSelectionListener);
        this.maxIdleText.addModifyListener(this.textModifyListener);
        this.maxIdleText.addVerifyListener(this.integerVerifyListener);
        this.inHistoryCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.inHistoryCheckbox.addSelectionListener(this.inHistoryCheckboxSelectionListener);
        this.inHistoryText.addModifyListener(this.textModifyListener);
        this.inHistoryText.addVerifyListener(this.integerVerifyListener);
        this.minimumDelayText.addModifyListener(this.textModifyListener);
        this.minimumDelayText.addVerifyListener(this.integerVerifyListener);
        this.maximumDelayText.addModifyListener(this.textModifyListener);
        this.maximumDelayText.addVerifyListener(this.integerVerifyListener);
    }

    private void removeListeners() {
        this.enabledCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.idText.removeModifyListener(this.textModifyListener);
        this.descriptionText.removeModifyListener(this.textModifyListener);
        this.checkQualityComboViewer.removeSelectionChangedListener(this.viewerSelectionChangedListener);
        this.checkQualityComboViewer.removeSelectionChangedListener(this.checkQualityComboViewerSelectionChangedListener);
        this.validatorText.removeModifyListener(this.textModifyListener);
        this.minimumLengthCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.minimumLengthCheckbox.removeSelectionListener(this.minimumLengthCheckboxSelectionListener);
        this.minimumLengthText.removeModifyListener(this.textModifyListener);
        this.minimumLengthText.removeVerifyListener(this.integerVerifyListener);
        this.maximumLengthCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.maximumLengthCheckbox.removeSelectionListener(this.maximumLengthCheckboxSelectionListener);
        this.maximumLengthText.removeModifyListener(this.textModifyListener);
        this.maximumLengthText.removeVerifyListener(this.integerVerifyListener);
        this.minimumAgeText.removeModifyListener(this.textModifyListener);
        this.minimumAgeText.removeVerifyListener(this.integerVerifyListener);
        this.maximumAgeText.removeModifyListener(this.textModifyListener);
        this.maximumAgeText.removeVerifyListener(this.integerVerifyListener);
        this.expireWarningCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.expireWarningCheckbox.removeSelectionListener(this.expireWarningCheckboxSelectionListener);
        this.expireWarningText.removeModifyListener(this.textModifyListener);
        this.expireWarningText.removeVerifyListener(this.integerVerifyListener);
        this.graceAuthenticationLimitCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.graceAuthenticationLimitCheckbox.removeSelectionListener(this.graceAuthenticationLimitCheckboxSelectionListener);
        this.graceAuthenticationLimitText.removeModifyListener(this.textModifyListener);
        this.graceAuthenticationLimitText.removeVerifyListener(this.integerVerifyListener);
        this.graceExpireCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.graceExpireCheckbox.removeSelectionListener(this.graceExpireCheckboxSelectionListener);
        this.graceExpireText.removeModifyListener(this.textModifyListener);
        this.graceExpireText.removeVerifyListener(this.integerVerifyListener);
        this.mustChangeCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.allowUserChangeCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.safeModifyCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.lockoutCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.lockoutDurationText.removeModifyListener(this.textModifyListener);
        this.lockoutDurationText.removeVerifyListener(this.integerVerifyListener);
        this.maxFailureText.removeModifyListener(this.textModifyListener);
        this.maxFailureText.removeVerifyListener(this.integerVerifyListener);
        this.failureCountIntervalText.removeModifyListener(this.textModifyListener);
        this.failureCountIntervalText.removeVerifyListener(this.integerVerifyListener);
        this.maxIdleCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.maxIdleCheckbox.removeSelectionListener(this.maxIdleCheckboxSelectionListener);
        this.maxIdleText.removeModifyListener(this.textModifyListener);
        this.maxIdleText.removeVerifyListener(this.integerVerifyListener);
        this.inHistoryCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.inHistoryCheckbox.removeSelectionListener(this.inHistoryCheckboxSelectionListener);
        this.inHistoryText.removeModifyListener(this.textModifyListener);
        this.inHistoryText.removeVerifyListener(this.integerVerifyListener);
        this.minimumDelayText.removeModifyListener(this.textModifyListener);
        this.minimumDelayText.removeVerifyListener(this.integerVerifyListener);
        this.maximumDelayText.removeModifyListener(this.textModifyListener);
        this.maximumDelayText.removeVerifyListener(this.integerVerifyListener);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.passwordPolicy = ssel.size() == 1 ? (PasswordPolicyBean)ssel.getFirstElement() : null;
        this.refresh();
    }

    public void commit(boolean onSave) {
        if (this.passwordPolicy != null) {
            this.passwordPolicy.setEnabled(this.enabledCheckbox.getSelection());
            this.passwordPolicy.setPwdId(ServerConfigurationEditorUtils.checkEmptyString(this.idText.getText()));
            this.passwordPolicy.setDescription(ServerConfigurationEditorUtils.checkEmptyString(this.descriptionText.getText()));
            this.passwordPolicy.setPwdCheckQuality(this.getPwdCheckQuality());
            this.passwordPolicy.setPwdValidator(ServerConfigurationEditorUtils.checkEmptyString(this.validatorText.getText()));
            if (this.minimumLengthCheckbox.getSelection()) {
                try {
                    this.passwordPolicy.setPwdMinLength(Integer.parseInt(this.minimumLengthText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.passwordPolicy.setPwdMinLength(0);
                }
            } else {
                this.passwordPolicy.setPwdMinLength(0);
            }
            if (this.maximumLengthCheckbox.getSelection()) {
                try {
                    this.passwordPolicy.setPwdMaxLength(Integer.parseInt(this.maximumLengthText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.passwordPolicy.setPwdMaxLength(0);
                }
            } else {
                this.passwordPolicy.setPwdMaxLength(0);
            }
            try {
                this.passwordPolicy.setPwdMinAge(Integer.parseInt(this.minimumAgeText.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.passwordPolicy.setPwdMinAge(0);
            }
            try {
                this.passwordPolicy.setPwdMaxAge(Integer.parseInt(this.maximumAgeText.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.passwordPolicy.setPwdMaxAge(0);
            }
            if (this.expireWarningCheckbox.getSelection()) {
                try {
                    this.passwordPolicy.setPwdExpireWarning(Integer.parseInt(this.expireWarningText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.passwordPolicy.setPwdExpireWarning(0);
                }
            } else {
                this.passwordPolicy.setPwdExpireWarning(0);
            }
            if (this.graceAuthenticationLimitCheckbox.getSelection()) {
                try {
                    this.passwordPolicy.setPwdGraceAuthNLimit(Integer.parseInt(this.graceAuthenticationLimitText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.passwordPolicy.setPwdGraceAuthNLimit(0);
                }
            } else {
                this.passwordPolicy.setPwdGraceAuthNLimit(0);
            }
            if (this.graceExpireCheckbox.getSelection()) {
                try {
                    this.passwordPolicy.setPwdGraceExpire(Integer.parseInt(this.graceExpireText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.passwordPolicy.setPwdGraceExpire(0);
                }
            } else {
                this.passwordPolicy.setPwdGraceExpire(0);
            }
            this.passwordPolicy.setPwdMustChange(this.mustChangeCheckbox.getSelection());
            this.passwordPolicy.setPwdAllowUserChange(this.allowUserChangeCheckbox.getSelection());
            this.passwordPolicy.setPwdSafeModify(this.safeModifyCheckbox.getSelection());
            this.passwordPolicy.setPwdLockout(this.lockoutCheckbox.getSelection());
            try {
                this.passwordPolicy.setPwdLockoutDuration(Integer.parseInt(this.lockoutDurationText.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.passwordPolicy.setPwdLockoutDuration(0);
            }
            try {
                this.passwordPolicy.setPwdMaxFailure(Integer.parseInt(this.maxFailureText.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.passwordPolicy.setPwdMaxFailure(0);
            }
            try {
                this.passwordPolicy.setPwdFailureCountInterval(Integer.parseInt(this.failureCountIntervalText.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.passwordPolicy.setPwdFailureCountInterval(0);
            }
            if (this.maxIdleCheckbox.getSelection()) {
                try {
                    this.passwordPolicy.setPwdMaxIdle(Integer.parseInt(this.maxIdleText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.passwordPolicy.setPwdMaxIdle(0);
                }
            } else {
                this.passwordPolicy.setPwdMaxIdle(0);
            }
            if (this.inHistoryCheckbox.getSelection()) {
                try {
                    this.passwordPolicy.setPwdInHistory(Integer.parseInt(this.inHistoryText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.passwordPolicy.setPwdInHistory(0);
                }
            } else {
                this.passwordPolicy.setPwdInHistory(0);
            }
            try {
                this.passwordPolicy.setPwdMinDelay(Integer.parseInt(this.minimumDelayText.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.passwordPolicy.setPwdMinDelay(0);
            }
            try {
                this.passwordPolicy.setPwdMaxDelay(Integer.parseInt(this.maximumDelayText.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.passwordPolicy.setPwdMaxDelay(0);
            }
        }
    }

    private int getPwdCheckQuality() {
        StructuredSelection selection = (StructuredSelection)this.checkQualityComboViewer.getSelection();
        if (!selection.isEmpty()) {
            CheckQuality checkQuality = (CheckQuality)((Object)selection.getFirstElement());
            return checkQuality.getValue();
        }
        return CheckQuality.DISABLED.getValue();
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
        this.mform = form;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.removeListeners();
        if (this.passwordPolicy != null) {
            boolean isDefaultPasswordPolicy = PasswordPoliciesPage.isDefaultPasswordPolicy(this.passwordPolicy);
            this.enabledCheckbox.setSelection(this.passwordPolicy.isEnabled());
            this.idText.setText(ServerConfigurationEditorUtils.checkNull(this.passwordPolicy.getPwdId()));
            this.idText.setEnabled(!isDefaultPasswordPolicy);
            this.descriptionText.setText(ServerConfigurationEditorUtils.checkNull(this.passwordPolicy.getDescription()));
            this.descriptionText.setEnabled(!isDefaultPasswordPolicy);
            this.checkQualityComboViewer.setSelection((ISelection)new StructuredSelection((Object)CheckQuality.valueOf(this.passwordPolicy.getPwdCheckQuality())));
            this.validatorText.setText(ServerConfigurationEditorUtils.checkNull(this.passwordPolicy.getPwdValidator()));
            int minimumLength = this.passwordPolicy.getPwdMinLength();
            this.minimumLengthCheckbox.setSelection(minimumLength != 0);
            this.minimumLengthText.setText("" + minimumLength);
            int maximumLength = this.passwordPolicy.getPwdMaxLength();
            this.maximumLengthCheckbox.setSelection(maximumLength != 0);
            this.maximumLengthText.setText("" + maximumLength);
            if (this.getPwdCheckQuality() == 0) {
                this.minimumLengthCheckbox.setEnabled(false);
                this.minimumLengthText.setEnabled(false);
                this.maximumLengthCheckbox.setEnabled(false);
                this.maximumLengthText.setEnabled(false);
            } else {
                this.minimumLengthCheckbox.setEnabled(true);
                this.minimumLengthText.setEnabled(minimumLength != 0);
                this.maximumLengthCheckbox.setEnabled(true);
                this.maximumLengthText.setEnabled(maximumLength != 0);
            }
            this.minimumAgeText.setText("" + this.passwordPolicy.getPwdMinAge());
            this.maximumAgeText.setText("" + this.passwordPolicy.getPwdMaxAge());
            int expireWarning = this.passwordPolicy.getPwdExpireWarning();
            this.expireWarningCheckbox.setSelection(expireWarning != 0);
            this.expireWarningText.setText("" + expireWarning);
            this.expireWarningText.setEnabled(expireWarning != 0);
            int graceAuthenticationLimit = this.passwordPolicy.getPwdGraceAuthNLimit();
            this.graceAuthenticationLimitCheckbox.setSelection(graceAuthenticationLimit != 0);
            this.graceAuthenticationLimitText.setText("" + graceAuthenticationLimit);
            this.graceAuthenticationLimitText.setEnabled(graceAuthenticationLimit != 0);
            int graceExpire = this.passwordPolicy.getPwdGraceExpire();
            this.graceExpireCheckbox.setSelection(graceExpire != 0);
            this.graceExpireText.setText("" + graceExpire);
            this.graceExpireText.setEnabled(graceExpire != 0);
            this.mustChangeCheckbox.setSelection(this.passwordPolicy.isPwdMustChange());
            this.allowUserChangeCheckbox.setSelection(this.passwordPolicy.isPwdAllowUserChange());
            this.safeModifyCheckbox.setSelection(this.passwordPolicy.isPwdSafeModify());
            this.lockoutCheckbox.setSelection(this.passwordPolicy.isPwdLockout());
            this.lockoutDurationText.setText("" + this.passwordPolicy.getPwdLockoutDuration());
            this.maxFailureText.setText("" + this.passwordPolicy.getPwdMaxFailure());
            this.failureCountIntervalText.setText("" + this.passwordPolicy.getPwdFailureCountInterval());
            int maxIdle = this.passwordPolicy.getPwdMaxIdle();
            this.maxIdleCheckbox.setSelection(maxIdle != 0);
            this.maxIdleText.setText("" + maxIdle);
            this.maxIdleText.setEnabled(maxIdle != 0);
            int inHistory = this.passwordPolicy.getPwdInHistory();
            this.inHistoryCheckbox.setSelection(inHistory != 0);
            this.inHistoryText.setText("" + inHistory);
            this.inHistoryText.setEnabled(inHistory != 0);
            this.minimumDelayText.setText("" + this.passwordPolicy.getPwdMinDelay());
            this.maximumDelayText.setText("" + this.passwordPolicy.getPwdMaxDelay());
        }
        this.addListeners();
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    private static enum CheckQuality {
        DISABLED(0),
        RELAXED(1),
        STRICT(2);

        private int value;

        private CheckQuality(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this) {
                case DISABLED: {
                    return "Disabled";
                }
                case RELAXED: {
                    return "Relaxed";
                }
                case STRICT: {
                    return "Strict";
                }
            }
            return super.toString();
        }

        public static CheckQuality valueOf(String string) {
            return Enum.valueOf(CheckQuality.class, string);
        }
    }
}

