/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.subtree.AdministrativeRole;
import org.apache.directory.api.ldap.util.tree.DnNode;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.administrative.AbstractAdministrativePoint;
import org.apache.directory.server.core.api.administrative.AccessControlAAP;
import org.apache.directory.server.core.api.administrative.AccessControlAdministrativePoint;
import org.apache.directory.server.core.api.administrative.AccessControlIAP;
import org.apache.directory.server.core.api.administrative.AccessControlSAP;
import org.apache.directory.server.core.api.administrative.AdministrativePoint;
import org.apache.directory.server.core.api.administrative.CollectiveAttributeAAP;
import org.apache.directory.server.core.api.administrative.CollectiveAttributeAdministrativePoint;
import org.apache.directory.server.core.api.administrative.CollectiveAttributeIAP;
import org.apache.directory.server.core.api.administrative.CollectiveAttributeSAP;
import org.apache.directory.server.core.api.administrative.SubschemaAAP;
import org.apache.directory.server.core.api.administrative.SubschemaAdministrativePoint;
import org.apache.directory.server.core.api.administrative.SubschemaSAP;
import org.apache.directory.server.core.api.administrative.TriggerExecutionAAP;
import org.apache.directory.server.core.api.administrative.TriggerExecutionAdministrativePoint;
import org.apache.directory.server.core.api.administrative.TriggerExecutionIAP;
import org.apache.directory.server.core.api.administrative.TriggerExecutionSAP;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdministrativePointInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AdministrativePointInterceptor.class);
    private PartitionNexus nexus;
    private static final Set<String> ROLES = new HashSet<String>();
    private static final Map<String, String> ROLES_OID;
    private static final Set<String> INNER_AREA_ROLES;
    private static final Set<String> SPECIFIC_AREA_ROLES;
    private ReentrantReadWriteLock mutex = new ReentrantReadWriteLock();

    public AdministrativePointInterceptor() {
        super(InterceptorEnum.ADMINISTRATIVE_POINT_INTERCEPTOR);
    }

    public void lockRead() {
        this.mutex.readLock().lock();
    }

    public void lockWrite() {
        this.mutex.writeLock().lock();
    }

    public void unlock() {
        if (this.mutex.isWriteLockedByCurrentThread()) {
            this.mutex.writeLock().unlock();
        } else {
            this.mutex.readLock().unlock();
        }
    }

    private void createAdministrativePoints(Attribute adminPoint, Dn dn, String uuid) throws LdapException {
        if (this.isAAP(adminPoint)) {
            AccessControlAAP acAap = new AccessControlAAP(dn, uuid);
            this.directoryService.getAccessControlAPCache().add(dn, acAap);
            CollectiveAttributeAAP caAap = new CollectiveAttributeAAP(dn, uuid);
            this.directoryService.getCollectiveAttributeAPCache().add(dn, caAap);
            TriggerExecutionAAP teAap = new TriggerExecutionAAP(dn, uuid);
            this.directoryService.getTriggerExecutionAPCache().add(dn, teAap);
            SubschemaAAP ssAap = new SubschemaAAP(dn, uuid);
            this.directoryService.getSubschemaAPCache().add(dn, ssAap);
            return;
        }
        for (Value value : adminPoint) {
            AbstractAdministrativePoint iap;
            AbstractAdministrativePoint sap;
            String role = value.getString();
            if (this.isAccessControlSpecificRole(role)) {
                sap = new AccessControlSAP(dn, uuid);
                this.directoryService.getAccessControlAPCache().add(dn, (AccessControlAdministrativePoint)sap);
                continue;
            }
            if (this.isAccessControlInnerRole(role)) {
                iap = new AccessControlIAP(dn, uuid);
                this.directoryService.getAccessControlAPCache().add(dn, (AccessControlAdministrativePoint)iap);
                continue;
            }
            if (this.isCollectiveAttributeSpecificRole(role)) {
                sap = new CollectiveAttributeSAP(dn, uuid);
                this.directoryService.getCollectiveAttributeAPCache().add(dn, (CollectiveAttributeAdministrativePoint)sap);
                continue;
            }
            if (this.isCollectiveAttributeInnerRole(role)) {
                iap = new CollectiveAttributeIAP(dn, uuid);
                this.directoryService.getCollectiveAttributeAPCache().add(dn, (CollectiveAttributeAdministrativePoint)iap);
                continue;
            }
            if (this.isSubschemaSpecficRole(role)) {
                sap = new SubschemaSAP(dn, uuid);
                this.directoryService.getSubschemaAPCache().add(dn, (SubschemaAdministrativePoint)sap);
                continue;
            }
            if (this.isTriggerExecutionSpecificRole(role)) {
                sap = new TriggerExecutionSAP(dn, uuid);
                this.directoryService.getTriggerExecutionAPCache().add(dn, (TriggerExecutionAdministrativePoint)sap);
                continue;
            }
            if (!this.isTriggerExecutionInnerRole(role)) continue;
            iap = new TriggerExecutionIAP(dn, uuid);
            this.directoryService.getTriggerExecutionAPCache().add(dn, (TriggerExecutionAdministrativePoint)iap);
        }
    }

    private void addRole(String role, Dn dn, String uuid, DnNode<AccessControlAdministrativePoint> acapCache, DnNode<CollectiveAttributeAdministrativePoint> caapCache, DnNode<TriggerExecutionAdministrativePoint> teapCache, DnNode<SubschemaAdministrativePoint> ssapCache) throws LdapException {
        if (this.isAutonomousAreaRole(role)) {
            AccessControlAAP acAap = new AccessControlAAP(dn, uuid);
            acapCache.add(dn, acAap);
            CollectiveAttributeAAP caAap = new CollectiveAttributeAAP(dn, uuid);
            caapCache.add(dn, caAap);
            TriggerExecutionAAP teAap = new TriggerExecutionAAP(dn, uuid);
            teapCache.add(dn, teAap);
            SubschemaAAP ssAap = new SubschemaAAP(dn, uuid);
            ssapCache.add(dn, ssAap);
            return;
        }
        if (this.isAccessControlSpecificRole(role)) {
            AccessControlSAP sap = new AccessControlSAP(dn, uuid);
            acapCache.add(dn, sap);
            return;
        }
        if (this.isAccessControlInnerRole(role)) {
            AccessControlIAP iap = new AccessControlIAP(dn, uuid);
            acapCache.add(dn, iap);
            return;
        }
        if (this.isCollectiveAttributeSpecificRole(role)) {
            CollectiveAttributeSAP sap = new CollectiveAttributeSAP(dn, uuid);
            caapCache.add(dn, sap);
            return;
        }
        if (this.isCollectiveAttributeInnerRole(role)) {
            CollectiveAttributeIAP iap = new CollectiveAttributeIAP(dn, uuid);
            caapCache.add(dn, iap);
            return;
        }
        if (this.isSubschemaSpecficRole(role)) {
            SubschemaSAP sap = new SubschemaSAP(dn, uuid);
            ssapCache.add(dn, sap);
            return;
        }
        if (this.isTriggerExecutionSpecificRole(role)) {
            TriggerExecutionSAP sap = new TriggerExecutionSAP(dn, uuid);
            teapCache.add(dn, sap);
            return;
        }
        if (this.isTriggerExecutionInnerRole(role)) {
            TriggerExecutionIAP iap = new TriggerExecutionIAP(dn, uuid);
            teapCache.add(dn, iap);
        }
    }

    private void delRole(String role, Dn dn, String uuid, DnNode<AccessControlAdministrativePoint> acapCache, DnNode<CollectiveAttributeAdministrativePoint> caapCache, DnNode<TriggerExecutionAdministrativePoint> teapCache, DnNode<SubschemaAdministrativePoint> ssapCache) throws LdapException {
        if (this.isAutonomousAreaRole(role)) {
            acapCache.remove(dn);
            caapCache.remove(dn);
            teapCache.remove(dn);
            ssapCache.remove(dn);
            return;
        }
        if (this.isAccessControlSpecificRole(role) || this.isAccessControlInnerRole(role)) {
            acapCache.remove(dn);
            return;
        }
        if (this.isCollectiveAttributeSpecificRole(role) || this.isCollectiveAttributeInnerRole(role)) {
            caapCache.remove(dn);
            return;
        }
        if (this.isSubschemaSpecficRole(role)) {
            ssapCache.remove(dn);
            return;
        }
        if (this.isTriggerExecutionSpecificRole(role) || this.isTriggerExecutionInnerRole(role)) {
            teapCache.remove(dn);
        }
    }

    private AdministrativePoint getParent(AdministrativePoint ap, List<AdministrativePoint> aps, AdministrativeRole role, DnNode<List<AdministrativePoint>> currentNode) {
        AdministrativePoint parent = null;
        for (AdministrativePoint adminPoint : aps) {
            if (adminPoint.isAutonomous() || adminPoint.getRole() == ap.getRole()) {
                return adminPoint;
            }
            if (adminPoint.getRole() != role) continue;
            parent = adminPoint;
        }
        if (parent != null) {
            return parent;
        }
        if (currentNode.hasParent()) {
            return this.findParent(ap, currentNode);
        }
        return null;
    }

    private AdministrativePoint findParent(AdministrativePoint ap, DnNode<List<AdministrativePoint>> currentNode) {
        List<AdministrativePoint> aps = currentNode.getElement();
        if (aps != null) {
            switch (ap.getRole()) {
                case AutonomousArea: {
                    AdministrativePoint currentAp = aps.get(0);
                    if (currentAp.isAutonomous()) {
                        return currentAp;
                    }
                    if (currentNode.hasParent()) {
                        return this.findParent(ap, currentNode);
                    }
                    return null;
                }
                case AccessControlInnerArea: {
                    return this.getParent(ap, aps, AdministrativeRole.AccessControlSpecificArea, currentNode);
                }
                case CollectiveAttributeInnerArea: {
                    return this.getParent(ap, aps, AdministrativeRole.CollectiveAttributeSpecificArea, currentNode);
                }
                case TriggerExecutionInnerArea: {
                    return this.getParent(ap, aps, AdministrativeRole.TriggerExecutionSpecificArea, currentNode);
                }
                case AccessControlSpecificArea: {
                    return this.getParent(ap, aps, AdministrativeRole.AccessControlSpecificArea, currentNode);
                }
                case CollectiveAttributeSpecificArea: {
                    return this.getParent(ap, aps, AdministrativeRole.CollectiveAttributeSpecificArea, currentNode);
                }
                case SubSchemaSpecificArea: {
                    return this.getParent(ap, aps, AdministrativeRole.SubSchemaSpecificArea, currentNode);
                }
                case TriggerExecutionSpecificArea: {
                    return this.getParent(ap, aps, AdministrativeRole.TriggerExecutionSpecificArea, currentNode);
                }
            }
            return null;
        }
        if (currentNode.hasParent()) {
            return this.findParent(ap, currentNode.getParent());
        }
        return null;
    }

    private void checkAddRole(Value role, Attribute adminPoint, Dn dn) throws LdapException {
        String roleStr = Strings.toLowerCaseAscii(Strings.trim(role.getString()));
        if (!ROLES.contains(roleStr)) {
            String message = "Cannot add the given role, it's not a valid one :" + role;
            LOG.error(message);
            throw new LdapUnwillingToPerformException(message);
        }
        if (this.isAutonomousAreaRole(roleStr)) {
            if (adminPoint.size() > 1) {
                String message = "Cannot add an Autonomous Administratve Point when some other roles are added : " + adminPoint;
                LOG.error(message);
                throw new LdapUnwillingToPerformException(message);
            }
            return;
        }
        if (adminPoint.contains("autonomousArea")) {
            String message = "Cannot add a role when an Autonomous Administratve Point is already present : " + adminPoint;
            LOG.error(message);
            throw new LdapUnwillingToPerformException(message);
        }
        this.checkInnerSpecificMix(roleStr, adminPoint);
        if (this.isIAP(roleStr)) {
            this.checkIAPHasParent(roleStr, adminPoint, dn);
        }
    }

    private void checkDelRole(Value role, Attribute adminPoint, Dn dn) throws LdapException {
        String roleStr = Strings.toLowerCaseAscii(Strings.trim(role.getString()));
        if (!ROLES.contains(roleStr)) {
            String message = "Cannot delete the given role, it's not a valid one :" + role;
            LOG.error(message);
            throw new LdapUnwillingToPerformException(message);
        }
        if (this.isAutonomousAreaRole(roleStr)) {
            DnNode<AccessControlAdministrativePoint> acAps = this.directoryService.getAccessControlAPCache();
            if (!acAps.hasParent(dn)) {
                List<AccessControlAdministrativePoint> children = acAps.getDescendantElements(dn);
                for (AccessControlAdministrativePoint accessControlAdministrativePoint : children) {
                    if (!accessControlAdministrativePoint.isInner()) continue;
                    String message = "Cannot delete the given role, the " + accessControlAdministrativePoint.getDn() + " AccessControl IAP will remain orphan";
                    LOG.error(message);
                    throw new LdapUnwillingToPerformException(message);
                }
            }
            DnNode<CollectiveAttributeAdministrativePoint> caAps = this.directoryService.getCollectiveAttributeAPCache();
            if (!acAps.hasParent(dn)) {
                List<CollectiveAttributeAdministrativePoint> children = caAps.getDescendantElements(dn);
                for (CollectiveAttributeAdministrativePoint child : children) {
                    if (!child.isInner()) continue;
                    String message = "Cannot delete the given role, the " + child.getDn() + " CollectiveAttribute IAP will remain orphan";
                    LOG.error(message);
                    throw new LdapUnwillingToPerformException(message);
                }
            }
            DnNode<TriggerExecutionAdministrativePoint> teAps = this.directoryService.getTriggerExecutionAPCache();
            if (!acAps.hasParent(dn)) {
                List<TriggerExecutionAdministrativePoint> list = teAps.getDescendantElements(dn);
                for (TriggerExecutionAdministrativePoint child : list) {
                    if (!child.isInner()) continue;
                    String message = "Cannot delete the given role, the " + child.getDn() + " TriggerExecution IAP will remain orphan";
                    LOG.error(message);
                    throw new LdapUnwillingToPerformException(message);
                }
            }
        }
    }

    private List<Entry> getAdministrativePoints() throws LdapException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"administrativeRole", "entryUUID"});
        PresenceNode filter = new PresenceNode(this.directoryService.getAtProvider().getAdministrativeRole());
        CoreSession adminSession = this.directoryService.getAdminSession();
        SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, Dn.ROOT_DSE, filter, controls);
        Partition partition = this.nexus.getPartition(Dn.ROOT_DSE);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        searchOperationContext.setPartition(partition);
        try (PartitionReadTxn partitionTxn = partition.beginReadTransaction();){
            searchOperationContext.setTransaction(partitionTxn);
            EntryFilteringCursor results = this.nexus.search(searchOperationContext);
            try {
                while (results.next()) {
                    Entry entry = (Entry)results.get();
                    entries.add(entry);
                }
                results.close();
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new LdapOtherException(e.getMessage(), e);
        }
        return entries;
    }

    private boolean isValidRole(String role) {
        return ROLES.contains(Strings.toLowerCaseAscii(Strings.trim(role)));
    }

    private void addAdminPointCache(List<Entry> adminPointEntries) throws LdapException {
        for (Entry adminPointEntry : adminPointEntries) {
            Dn dn = adminPointEntry.getDn();
            String uuid = adminPointEntry.get(this.directoryService.getAtProvider().getEntryUUID()).getString();
            Attribute adminPoint = adminPointEntry.get(this.directoryService.getAtProvider().getAdministrativeRole());
            this.createAdministrativePoints(adminPoint, dn, uuid);
        }
    }

    private void deleteAdminPointCache(Attribute adminPoint, DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        for (Value value : adminPoint) {
            String role = value.getString();
            if (this.isAutonomousAreaRole(role)) {
                this.directoryService.getAccessControlAPCache().remove(dn);
                this.directoryService.getCollectiveAttributeAPCache().remove(dn);
                this.directoryService.getTriggerExecutionAPCache().remove(dn);
                this.directoryService.getSubschemaAPCache().remove(dn);
                return;
            }
            if (this.isAccessControlSpecificRole(role) || this.isAccessControlInnerRole(role)) {
                this.directoryService.getAccessControlAPCache().remove(dn);
                continue;
            }
            if (this.isCollectiveAttributeSpecificRole(role) || this.isCollectiveAttributeInnerRole(role)) {
                this.directoryService.getCollectiveAttributeAPCache().remove(dn);
                continue;
            }
            if (this.isSubschemaSpecficRole(role)) {
                this.directoryService.getSubschemaAPCache().remove(dn);
                continue;
            }
            if (!this.isTriggerExecutionSpecificRole(role) && !this.isTriggerExecutionInnerRole(role)) continue;
            this.directoryService.getTriggerExecutionAPCache().remove(dn);
        }
    }

    private boolean isAccessControlInnerRole(String role) {
        return role.equalsIgnoreCase("accessControlInnerArea") || role.equals("2.5.23.3");
    }

    private boolean isAccessControlSpecificRole(String role) {
        return role.equalsIgnoreCase("accessControlSpecificArea") || role.equals("2.5.23.2");
    }

    private boolean isCollectiveAttributeInnerRole(String role) {
        return role.equalsIgnoreCase("collectiveAttributeInnerArea") || role.equals("2.5.23.6");
    }

    private boolean isCollectiveAttributeSpecificRole(String role) {
        return role.equalsIgnoreCase("collectiveAttributeSpecificArea") || role.equals("2.5.23.5");
    }

    private boolean isTriggerExecutionInnerRole(String role) {
        return role.equalsIgnoreCase("triggerExecutionInnerArea") || role.equals("1.3.6.1.4.1.18060.0.4.1.6.2");
    }

    private boolean isTriggerExecutionSpecificRole(String role) {
        return role.equalsIgnoreCase("triggerExecutionSpecificArea") || role.equals("1.3.6.1.4.1.18060.0.4.1.6.1");
    }

    private boolean isSubschemaSpecficRole(String role) {
        return role.equalsIgnoreCase("subSchemaSpecificArea") || role.equals("2.5.23.4");
    }

    private boolean isAutonomousAreaRole(String role) {
        return role.equalsIgnoreCase("autonomousArea") || role.equals("2.5.23.1");
    }

    private boolean isAAP(Attribute adminPoint) {
        return adminPoint.contains("autonomousArea") || adminPoint.contains("2.5.23.1");
    }

    private boolean hasAccessControlSpecificRole(Attribute adminPoint) {
        return adminPoint.contains("accessControlSpecificArea") || adminPoint.contains("2.5.23.2");
    }

    private boolean isIAP(String role) {
        return INNER_AREA_ROLES.contains(role);
    }

    private boolean hasCollectiveAttributeSpecificRole(Attribute adminPoint) {
        return adminPoint.contains("collectiveAttributeSpecificArea") || adminPoint.contains("2.5.23.5");
    }

    private boolean hasTriggerExecutionSpecificRole(Attribute adminPoint) {
        return adminPoint.contains("triggerExecutionSpecificArea") || adminPoint.contains("1.3.6.1.4.1.18060.0.4.1.6.1");
    }

    private void checkInnerSpecificMix(String role, Attribute adminPoint) throws LdapUnwillingToPerformException {
        if (this.isAccessControlInnerRole(role)) {
            if (this.hasAccessControlSpecificRole(adminPoint)) {
                String message = "Cannot add a specific Administrative Point and the same inner Administrative point at the same time : " + adminPoint;
                LOG.error(message);
                throw new LdapUnwillingToPerformException(message);
            }
            return;
        }
        if (this.isCollectiveAttributeInnerRole(role)) {
            if (this.hasCollectiveAttributeSpecificRole(adminPoint)) {
                String message = "Cannot add a specific Administrative Point and the same inner Administrative point at the same time : " + adminPoint;
                LOG.error(message);
                throw new LdapUnwillingToPerformException(message);
            }
            return;
        }
        if (this.isTriggerExecutionInnerRole(role) && this.hasTriggerExecutionSpecificRole(adminPoint)) {
            String message = "Cannot add a specific Administrative Point and the same inner Administrative point at the same time : " + adminPoint;
            LOG.error(message);
            throw new LdapUnwillingToPerformException(message);
        }
    }

    private void checkIAPHasParent(String role, Attribute adminPoint, Dn dn) throws LdapUnwillingToPerformException {
        if (this.isAccessControlInnerRole(role)) {
            DnNode<AccessControlAdministrativePoint> acCache = this.directoryService.getAccessControlAPCache();
            DnNode<AccessControlAdministrativePoint> parent = acCache.getNode(dn);
            if (parent == null) {
                String message = "Cannot add an IAP with no parent : " + adminPoint;
                LOG.error(message);
                throw new LdapUnwillingToPerformException(message);
            }
        } else if (this.isCollectiveAttributeInnerRole(role)) {
            DnNode<CollectiveAttributeAdministrativePoint> caCache = this.directoryService.getCollectiveAttributeAPCache();
            boolean hasAP = caCache.hasParentElement(dn);
            if (!hasAP) {
                String message = "Cannot add an IAP with no parent : " + adminPoint;
                LOG.error(message);
                throw new LdapUnwillingToPerformException(message);
            }
        } else if (this.isTriggerExecutionInnerRole(role)) {
            DnNode<TriggerExecutionAdministrativePoint> caCache = this.directoryService.getTriggerExecutionAPCache();
            DnNode<TriggerExecutionAdministrativePoint> parent = caCache.getNode(dn);
            if (parent == null) {
                String message = "Cannot add an IAP with no parent : " + adminPoint;
                LOG.error(message);
                throw new LdapUnwillingToPerformException(message);
            }
        } else {
            String message = "This is not an IAP : " + role;
            LOG.error(message);
            throw new LdapUnwillingToPerformException(message);
        }
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        LOG.debug("Initializing the AdministrativeInterceptor");
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        List<Entry> administrativePoints = this.getAdministrativePoints();
        this.lockWrite();
        try {
            this.addAdminPointCache(administrativePoints);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        LOG.debug(">>> Entering into the Administrative Interceptor, addRequest");
        Entry entry = addContext.getEntry();
        Dn dn = entry.getDn();
        Attribute adminPoint = entry.get(this.directoryService.getAtProvider().getAdministrativeRole());
        if (adminPoint == null) {
            this.next(addContext);
            LOG.debug("Exit from Administrative Interceptor, no AP in the added entry");
            return;
        }
        LOG.debug("Addition of an administrative point at {} for the role {}", (Object)dn, (Object)adminPoint);
        this.lockWrite();
        try {
            for (Value role : adminPoint) {
                this.checkAddRole(role, adminPoint, dn);
            }
            this.next(addContext);
            String apUuid = entry.get(this.directoryService.getAtProvider().getEntryUUID()).getString();
            this.createAdministrativePoints(adminPoint, dn, apUuid);
        }
        finally {
            this.unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added an Administrative Point at {}", (Object)dn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        LOG.debug(">>> Entering into the Administrative Interceptor, delRequest");
        Entry entry = deleteContext.getEntry();
        Dn dn = entry.getDn();
        Attribute adminPoint = entry.get(this.directoryService.getAtProvider().getAdministrativeRole());
        if (adminPoint == null) {
            this.next(deleteContext);
            LOG.debug("Exit from Administrative Interceptor");
            return;
        }
        LOG.debug("Deletion of an administrative point at {} for the role {}", (Object)dn, (Object)adminPoint);
        this.lockWrite();
        try {
            for (Value role : adminPoint) {
                if (this.isValidRole(role.getString())) continue;
                String message = "Cannot remove the given role, it's not a valid one :" + role;
                LOG.error(message);
                throw new LdapUnwillingToPerformException(message);
            }
            this.next(deleteContext);
            this.deleteAdminPointCache(adminPoint, deleteContext);
        }
        finally {
            this.unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleted an Administrative Point at {}", (Object)dn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        LOG.debug(">>> Entering into the Administrative Interceptor, modifyRequest");
        List<Modification> modifications = modifyContext.getModItems();
        Dn dn = modifyContext.getDn();
        String uuid = modifyContext.getEntry().get(this.directoryService.getAtProvider().getEntryUUID()).getString();
        boolean adminRolePresent = false;
        for (Modification modification : modifications) {
            if (modification.getAttribute().getAttributeType() != this.directoryService.getAtProvider().getAdministrativeRole()) continue;
            adminRolePresent = true;
            break;
        }
        if (adminRolePresent) {
            Attribute modifiedAdminRole = ((ClonedServerEntry)modifyContext.getEntry()).getOriginalEntry().get(this.directoryService.getAtProvider().getAdministrativeRole());
            modifiedAdminRole = modifiedAdminRole == null ? new DefaultAttribute(this.directoryService.getAtProvider().getAdministrativeRole()) : modifiedAdminRole.clone();
            try {
                this.lockWrite();
                DnNode<AccessControlAdministrativePoint> acapCache = this.directoryService.getAccessControlAPCache();
                DnNode<CollectiveAttributeAdministrativePoint> caapCache = this.directoryService.getCollectiveAttributeAPCache();
                DnNode<TriggerExecutionAdministrativePoint> teapCache = this.directoryService.getTriggerExecutionAPCache();
                DnNode<SubschemaAdministrativePoint> ssapCache = this.directoryService.getSubschemaAPCache();
                block9: for (Modification modification : modifications) {
                    Attribute attribute = modification.getAttribute();
                    if (attribute.getAttributeType() != this.directoryService.getAtProvider().getAdministrativeRole()) continue;
                    switch (modification.getOperation()) {
                        case ADD_ATTRIBUTE: {
                            for (Value role : attribute) {
                                this.addRole(role.getString(), dn, uuid, acapCache, caapCache, teapCache, ssapCache);
                                modifiedAdminRole.add(role);
                            }
                            continue block9;
                        }
                        case REMOVE_ATTRIBUTE: {
                            if (attribute.size() == 0) {
                                for (Value role : modifiedAdminRole) {
                                    this.delRole(role.getString(), dn, uuid, acapCache, caapCache, teapCache, ssapCache);
                                }
                                modifiedAdminRole.clear();
                                break;
                            }
                            for (Value value : attribute) {
                                if (!this.isValidRole(value.getString())) {
                                    String msg = "Invalid role : " + value.getString();
                                    LOG.error(msg);
                                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
                                }
                                if (!modifiedAdminRole.contains(value)) {
                                    String msg = "Cannot remove the administrative role value" + value + ", it does not exist";
                                    LOG.error(msg);
                                    throw new LdapNoSuchAttributeException(msg);
                                }
                                modifiedAdminRole.remove(value);
                                this.delRole(value.getString(), dn, uuid, acapCache, caapCache, teapCache, ssapCache);
                            }
                            continue block9;
                        }
                        case REPLACE_ATTRIBUTE: {
                            if (modifyContext.isReplEvent() && modifyContext.getSession().isAdministrator()) continue block9;
                            String msg = "Cannot replace an administrative role, the opertion is not supported";
                            LOG.error(msg);
                            throw new LdapUnwillingToPerformException(msg);
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected modify operation " + (Object)((Object)modification.getOperation()));
                        }
                    }
                }
            }
            finally {
                this.unlock();
            }
        }
        this.next(modifyContext);
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        LOG.debug(">>> Entering into the Administrative Interceptor, moveRequest");
        Entry entry = moveContext.getOriginalEntry();
        Attribute adminPoint = entry.get(this.directoryService.getAtProvider().getAdministrativeRole());
        if (adminPoint == null) {
            this.next(moveContext);
            LOG.debug("Exit from Administrative Interceptor");
            return;
        }
        String message = "Cannot move an Administrative Point in the current version";
        LOG.error(message);
        throw new LdapUnwillingToPerformException(message);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        LOG.debug(">>> Entering into the Administrative Interceptor, moveAndRenameRequest");
        Entry entry = moveAndRenameContext.getOriginalEntry();
        Attribute adminPoint = entry.get(this.directoryService.getAtProvider().getAdministrativeRole());
        if (adminPoint == null) {
            this.next(moveAndRenameContext);
            LOG.debug("Exit from Administrative Interceptor");
            return;
        }
        String message = "Cannot move and rename an Administrative Point in the current version";
        LOG.error(message);
        throw new LdapUnwillingToPerformException(message);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        LOG.debug(">>> Entering into the Administrative Interceptor, renameRequest");
        Entry entry = renameContext.getEntry();
        Attribute adminPoint = entry.get(this.directoryService.getAtProvider().getAdministrativeRole());
        if (adminPoint == null) {
            this.next(renameContext);
            LOG.debug("Exit from Administrative Interceptor");
            return;
        }
        String message = "Cannot rename an Administrative Point in the current version";
        LOG.error(message);
        throw new LdapUnwillingToPerformException(message);
    }

    static {
        ROLES.add(Strings.toLowerCaseAscii("autonomousArea"));
        ROLES.add("2.5.23.1");
        ROLES.add(Strings.toLowerCaseAscii("accessControlSpecificArea"));
        ROLES.add("2.5.23.2");
        ROLES.add(Strings.toLowerCaseAscii("accessControlInnerArea"));
        ROLES.add("2.5.23.3");
        ROLES.add(Strings.toLowerCaseAscii("collectiveAttributeSpecificArea"));
        ROLES.add("2.5.23.5");
        ROLES.add(Strings.toLowerCaseAscii("collectiveAttributeInnerArea"));
        ROLES.add("2.5.23.6");
        ROLES.add(Strings.toLowerCaseAscii("subSchemaSpecificArea"));
        ROLES.add("2.5.23.4");
        ROLES.add(Strings.toLowerCaseAscii("triggerExecutionSpecificArea"));
        ROLES.add("1.3.6.1.4.1.18060.0.4.1.6.1");
        ROLES.add(Strings.toLowerCaseAscii("triggerExecutionInnerArea"));
        ROLES.add("1.3.6.1.4.1.18060.0.4.1.6.2");
        ROLES_OID = new HashMap<String, String>();
        ROLES_OID.put(Strings.toLowerCaseAscii("autonomousArea"), "2.5.23.1");
        ROLES_OID.put(Strings.toLowerCaseAscii("accessControlSpecificArea"), "2.5.23.2");
        ROLES_OID.put(Strings.toLowerCaseAscii("accessControlInnerArea"), "2.5.23.3");
        ROLES_OID.put(Strings.toLowerCaseAscii("collectiveAttributeSpecificArea"), "2.5.23.5");
        ROLES_OID.put(Strings.toLowerCaseAscii("collectiveAttributeInnerArea"), "2.5.23.6");
        ROLES_OID.put(Strings.toLowerCaseAscii("subSchemaSpecificArea"), "2.5.23.4");
        ROLES_OID.put(Strings.toLowerCaseAscii("triggerExecutionSpecificArea"), "1.3.6.1.4.1.18060.0.4.1.6.1");
        ROLES_OID.put(Strings.toLowerCaseAscii("triggerExecutionInnerArea"), "1.3.6.1.4.1.18060.0.4.1.6.2");
        INNER_AREA_ROLES = new HashSet<String>();
        INNER_AREA_ROLES.add(Strings.toLowerCaseAscii("accessControlInnerArea"));
        INNER_AREA_ROLES.add("2.5.23.3");
        INNER_AREA_ROLES.add(Strings.toLowerCaseAscii("collectiveAttributeInnerArea"));
        INNER_AREA_ROLES.add("2.5.23.6");
        INNER_AREA_ROLES.add(Strings.toLowerCaseAscii("triggerExecutionInnerArea"));
        INNER_AREA_ROLES.add("1.3.6.1.4.1.18060.0.4.1.6.2");
        SPECIFIC_AREA_ROLES = new HashSet<String>();
        SPECIFIC_AREA_ROLES.add(Strings.toLowerCaseAscii("accessControlSpecificArea"));
        SPECIFIC_AREA_ROLES.add("2.5.23.2");
        SPECIFIC_AREA_ROLES.add(Strings.toLowerCaseAscii("collectiveAttributeSpecificArea"));
        SPECIFIC_AREA_ROLES.add("2.5.23.5");
        SPECIFIC_AREA_ROLES.add(Strings.toLowerCaseAscii("subSchemaSpecificArea"));
        SPECIFIC_AREA_ROLES.add("2.5.23.4");
        SPECIFIC_AREA_ROLES.add(Strings.toLowerCaseAscii("triggerExecutionSpecificArea"));
        SPECIFIC_AREA_ROLES.add("1.3.6.1.4.1.18060.0.4.1.6.1");
    }
}

