/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.enterprise.context.ContextNotActiveException;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewExpiredException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import org.apache.deltaspike.core.api.config.view.DefaultErrorView;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.config.view.navigation.ViewNavigationHandler;
import org.apache.deltaspike.core.api.projectstage.TestStage;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ProjectStageProducer;

public class DefaultErrorViewAwareExceptionHandlerWrapper
extends ExceptionHandlerWrapper
implements Deactivatable {
    private ExceptionHandler wrapped;
    private volatile ViewNavigationHandler viewNavigationHandler;

    protected DefaultErrorViewAwareExceptionHandlerWrapper() {
    }

    public DefaultErrorViewAwareExceptionHandlerWrapper(ExceptionHandler wrapped) {
        this.wrapped = wrapped;
    }

    public void handle() throws FacesException {
        this.lazyInit();
        Iterator exceptionQueuedEventIterator = this.getUnhandledExceptionQueuedEvents().iterator();
        while (exceptionQueuedEventIterator.hasNext()) {
            UIViewRoot uiViewRoot;
            ExceptionQueuedEventContext exceptionQueuedEventContext = (ExceptionQueuedEventContext)((ExceptionQueuedEvent)exceptionQueuedEventIterator.next()).getSource();
            Throwable throwable = exceptionQueuedEventContext.getException();
            String viewId = null;
            if (!this.isExceptionToHandle(throwable)) continue;
            FacesContext facesContext = exceptionQueuedEventContext.getContext();
            Flash flash = facesContext.getExternalContext().getFlash();
            if (throwable instanceof ViewExpiredException) {
                viewId = ((ViewExpiredException)throwable).getViewId();
            } else if (throwable instanceof ContextNotActiveException) {
                if (flash.containsKey((Object)ContextNotActiveException.class.getName())) break;
                viewId = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : ((ViewConfigResolver)BeanProvider.getContextualReference(ViewConfigResolver.class, (Annotation[])new Annotation[0])).getDefaultErrorViewConfigDescriptor().getViewId();
            }
            if (viewId == null || (uiViewRoot = facesContext.getApplication().getViewHandler().createView(facesContext, viewId)) == null) continue;
            if (facesContext.isProjectStage(ProjectStage.Development) || ProjectStageProducer.getInstance().getProjectStage() == org.apache.deltaspike.core.api.projectstage.ProjectStage.Development || ProjectStageProducer.getInstance().getProjectStage() instanceof TestStage) {
                throwable.printStackTrace();
            }
            facesContext.setViewRoot(uiViewRoot);
            exceptionQueuedEventIterator.remove();
            flash.put((Object)throwable.getClass().getName(), (Object)throwable);
            flash.keep(throwable.getClass().getName());
            this.viewNavigationHandler.navigateTo(DefaultErrorView.class);
            break;
        }
        this.wrapped.handle();
    }

    protected boolean isExceptionToHandle(Throwable throwable) {
        return throwable instanceof ViewExpiredException || throwable instanceof ContextNotActiveException;
    }

    private void lazyInit() {
        if (this.viewNavigationHandler == null) {
            this.viewNavigationHandler = (ViewNavigationHandler)BeanProvider.getContextualReference(ViewNavigationHandler.class, (Annotation[])new Annotation[0]);
        }
    }

    public ExceptionHandler getWrapped() {
        this.lazyInit();
        return this.wrapped;
    }
}

