/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.util.List;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.transformer.om.ColumnChildElementName;
import org.apache.torque.templates.transformer.om.FindHelper;

public class OMForeignKeyColumnTransformer {
    public void transform(SourceElement column, ControllerState controllerState) throws SourceTransformerException {
        if (!TorqueSchemaElementName.COLUMN.getName().equals(column.getName())) {
            throw new IllegalArgumentException("Illegal element Name " + column.getName());
        }
        Object localColumnName = column.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        SourceElement localTable = column.getParent();
        Object localTableName = localTable.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        SourceElement database = localTable.getParent();
        List tableForeignKeys = localTable.getChildren(TorqueSchemaElementName.FOREIGN_KEY.getName());
        block0: for (SourceElement foreignKey : tableForeignKeys) {
            List references = foreignKey.getChildren(TorqueSchemaElementName.REFERENCE.getName());
            for (SourceElement reference : references) {
                if (!localColumnName.equals(reference.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.LOCAL))) continue;
                SourceElement referencedColumn = new SourceElement((SourceElementName)ColumnChildElementName.REFERENCED_COLUMN);
                referencedColumn.getChildren().add(foreignKey);
                String foreignTableName = (String)foreignKey.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN_TABLE);
                String foreignColumnName = (String)reference.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN);
                SourceElement foreignTable = FindHelper.findTable(database, foreignTableName, true);
                if (foreignTable == null) {
                    throw new SourceTransformerException("Foreign table with name " + foreignTableName + " not found for a foreignKey of table " + localTableName);
                }
                SourceElement foreignColumn = FindHelper.findColumn(foreignTable, foreignColumnName);
                if (foreignColumn == null) {
                    throw new SourceTransformerException("Referenced Column with table name " + foreignTableName + " and column name " + foreignColumnName + " not found for a foreignKey of table " + localTableName);
                }
                referencedColumn.getChildren().add(foreignColumn);
                column.getChildren().add(referencedColumn);
                continue block0;
            }
        }
        List allTables = database.getChildren(TorqueSchemaElementName.TABLE.getName());
        for (SourceElement foreignTable : allTables) {
            String foreignTableName = (String)foreignTable.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
            List foreignKeys = foreignTable.getChildren(TorqueSchemaElementName.FOREIGN_KEY.getName());
            block3: for (SourceElement foreignKey : foreignKeys) {
                if (!localTableName.equals(foreignKey.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN_TABLE))) continue;
                List references = foreignKey.getChildren(TorqueSchemaElementName.REFERENCE.getName());
                for (SourceElement reference : references) {
                    Object referenceForeignColumnName = reference.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN);
                    String referenceLocalColumnName = (String)reference.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.LOCAL);
                    if (!localColumnName.equals(referenceForeignColumnName)) continue;
                    SourceElement referencingColumn = new SourceElement((SourceElementName)ColumnChildElementName.REFERENCING_COLUMN);
                    referencingColumn.getChildren().add(foreignKey);
                    referencingColumn.getChildren().add(foreignTable);
                    SourceElement localColumn = FindHelper.findColumn(foreignTable, referenceLocalColumnName);
                    if (localColumn == null) {
                        throw new SourceTransformerException("Local Column with column name " + referenceLocalColumnName + " not found in one of the foreignKeys of table " + foreignTableName);
                    }
                    referencingColumn.getChildren().add(localColumn);
                    column.getChildren().add(referencingColumn);
                    continue block3;
                }
            }
        }
    }
}

